/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summon;

import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.misc.SimpleItem;

public abstract class BossSpawningItem
extends SimpleItem {
    private final EnumParticleTypes[] timerParticles;
    private final SoundEvent throwingSound;

    public BossSpawningItem(String name, String registryName, @Nullable SoundEvent throwSound, EnumParticleTypes ... timerParticles) {
        super(name, registryName);
        this.timerParticles = timerParticles;
        this.throwingSound = throwSound;
    }

    public void handleTimerParticles(EntityItem entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        int index = (int)((float)ticksExisted / (float)lifespan * (float)this.timerParticles.length);
        if (field_77697_d.nextInt(1 + (lifespan - ticksExisted) / 20) == 0) {
            entityItem.field_70170_p.func_175688_a(this.timerParticles[index], posX, posY + 0.25, posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public abstract void spawnBoss(World var1, EntityPlayer var2, double var3, double var5, double var7);

    public abstract boolean canSpawnHere(World var1, EntityPlayer var2, double var3, double var5, double var7);

    public SoundEvent getThrowingSound() {
        return this.throwingSound;
    }
}

