/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.entity.misc.EntityLottoTotem;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ItemLottoTotem
extends Item {
    public ItemLottoTotem() {
        this.func_77655_b("LottoTotem");
        this.setRegistryName("aoa3:lotto_totem");
        this.func_77637_a(CreativeTabsRegister.MISC);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState targetBlockState = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (facing != EnumFacing.UP || targetBlockState.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            if (!world.func_72872_a(EntityLottoTotem.class, new AxisAlignedBB(pos).func_186662_g(4.0)).isEmpty()) {
                PlayerUtil.notifyPlayer((EntityPlayerMP)player, "message.feedback.lottoTotem.nearby", TextFormatting.RED);
                return EnumActionResult.FAIL;
            }
            ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>(5);
            spawnPositions.add(pos);
            if (this.populateSpawnPositions(world, pos, spawnPositions)) {
                player.func_184586_b(hand).func_190918_g(1);
                int selectedWinner = field_77697_d.nextInt(5);
                UUID winningUUID = MathHelper.func_188210_a();
                for (BlockPos spawnPos : spawnPositions) {
                    EntityLottoTotem totem = new EntityLottoTotem(world, spawnPos, winningUUID, player.func_110124_au());
                    if (selectedWinner == 0) {
                        totem.func_184221_a(winningUUID);
                    }
                    world.func_72838_d((Entity)totem);
                    --selectedWinner;
                }
                PlayerUtil.notifyPlayer((EntityPlayerMP)player, "message.feedback.lottoTotem.spawn", TextFormatting.GOLD);
            } else {
                PlayerUtil.notifyPlayer((EntityPlayerMP)player, "message.feedback.lottoTotem.space", TextFormatting.RED);
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean populateSpawnPositions(World world, BlockPos pos, ArrayList<BlockPos> spawnPositions) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos);
        for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; x += 2) {
            for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; z += 2) {
                checkPos.func_181079_c(x, pos.func_177956_o(), z);
                if (!world.func_180495_p(checkPos.func_177984_a()).func_185904_a().func_76222_j() || world.func_180495_p((BlockPos)checkPos).func_185899_b((IBlockAccess)world, (BlockPos)checkPos).func_193401_d((IBlockAccess)world, (BlockPos)checkPos, EnumFacing.UP) != BlockFaceShape.SOLID) continue;
                spawnPositions.add(checkPos.func_185334_h());
                if (spawnPositions.size() < 5) continue;
                return true;
            }
        }
        return false;
    }
}

