/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStack;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackProvider;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.mobs.precasia.EntityPrimitiveCarrotop;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class BlankRealmstone
extends Item {
    public BlankRealmstone() {
        this.func_77655_b("BlankRealmstone");
        this.setRegistryName("aoa3:blank_realmstone");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabsRegister.MISC);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)AdventOfAscension.instance(), Enums.ModGuis.REALMSTONE_MENU.guiId, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        BlockPos pos;
        IBlockState state;
        if (!entityItem.field_70170_p.field_72995_K && entityItem.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.precasia && (state = entityItem.field_70170_p.func_180495_p(pos = entityItem.func_180425_c())).func_177230_c() == Blocks.field_150459_bM && ((BlockCrops)state.func_177230_c()).func_185525_y(state)) {
            EntityPrimitiveCarrotop carrotop = new EntityPrimitiveCarrotop(entityItem.field_70170_p);
            carrotop.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
            entityItem.field_70170_p.func_72838_d((Entity)carrotop);
            entityItem.func_70106_y();
            entityItem.field_70170_p.func_175698_g(entityItem.func_180425_c());
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (player.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.creeponia && target instanceof AoATrader) {
            if (!player.field_70170_p.field_72995_K && ItemUtil.isPlayerEnvironmentallyProtected(player) && player.func_184586_b(hand).func_77973_b() == ItemRegister.BLANK_REALMSTONE) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)ItemRegister.VOX_PONDS_REALMSTONE));
                PlayerUtil.notifyPlayer((EntityPlayerMP)player, StringUtil.getLocaleString("message.dialogue.creeponiaBlankRealmstone." + AdventOfAscension.rand.nextInt(3)), new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && target.func_110143_aJ() <= 0.0f && target instanceof EntityHusk && attacker instanceof EntityPlayer) {
            attacker.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)ItemRegister.BARATHOS_REALMSTONE));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackProvider();
    }

    public static void handleAncientCavernTask(ItemStack stack, EntityLivingBase construct, EntityPlayer player) {
        CapabilityBaseMiscStack cap = (CapabilityBaseMiscStack)stack.getCapability(AdventMiscStackProvider.MISC_STACK, null);
        if (cap != null) {
            long currentWorldTime = construct.field_70170_p.func_82737_E();
            HashMap constructKillMap = cap.getObject() == null ? new HashMap(5) : (HashMap)cap.getObject();
            constructKillMap.entrySet().removeIf(entry -> (Long)entry.getValue() < currentWorldTime - 600L);
            constructKillMap.put(construct.getClass(), currentWorldTime);
            if (constructKillMap.size() >= 5) {
                stack.func_190918_g(1);
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)ItemRegister.ANCIENT_CAVERN_REALMSTONE));
            } else {
                cap.setObject(constructKillMap);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StringUtil.getLocaleString("item.BlankRealmstone.desc.1"));
        tooltip.add(StringUtil.getLocaleString("item.BlankRealmstone.desc.2"));
    }
}

