/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class ZargoniteArmour
extends AdventArmour {
    public ZargoniteArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_ZARGONITE, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.ZARGONITE;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && EntityUtil.isMagicDamage(event.getSource(), (Entity)event.getEntityLiving(), event.getAmount())) {
            event.setAmount((float)((double)event.getAmount() * (1.0 + 0.1 * (double)slots.size())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ZargoniteArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

