/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.entity.minions.EntityRosid;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class RosidianArmour
extends AdventArmour {
    public RosidianArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_ROSIDIAN, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.ROSIDIAN;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
        if (!EntityUtil.isEnvironmentalDamage(event.getSource()) && !EntityUtil.isPoisonDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
            if (slots == null) {
                if (event.getAmount() >= 4.0f) {
                    this.spawnRosid(plData.player());
                }
            } else if ((double)field_77697_d.nextFloat() < 0.04 * (double)slots.size()) {
                this.spawnRosid(plData.player());
            }
        }
    }

    private void spawnRosid(EntityPlayer pl) {
        EntityRosid rosid = new EntityRosid(pl.field_70170_p);
        rosid.func_193101_c(pl);
        rosid.func_70107_b(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v);
        pl.field_70170_p.func_72838_d((Entity)rosid);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.RosidianArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.RosidianArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
    }
}

