/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class PurityArmour
extends AdventArmour {
    public PurityArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_PURITY, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.PURITY;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        if (slots == null && !plData.player().func_193076_bZ().isEmpty()) {
            this.checkAndRemoveEffects(plData.player(), MobEffects.field_76437_t, MobEffects.field_76421_d, MobEffects.field_76419_f, MobEffects.field_76440_q, MobEffects.field_76431_k);
        }
    }

    private void checkAndRemoveEffects(EntityPlayer pl, Potion ... effects) {
        for (Potion effect : effects) {
            if (!pl.func_70644_a(effect)) continue;
            pl.func_184589_d(effect);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.PurityArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

