/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class CrystallisArmour
extends AdventArmour {
    public CrystallisArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_CRYSTALLIS, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.CRYSTALLIS;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            if (slots == null && EntityUtil.isMeleeDamage(event.getSource()) || EntityUtil.isRangedDamage(event.getSource(), (Entity)plData.player(), event.getAmount())) {
                event.getSource().func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)plData.player()), event.getAmount());
                plData.player().field_71071_by.func_70449_g(event.getAmount() * 0.5f);
            } else if (slots != null && plData.equipment().getCurrentFullArmourSet() != this.setType() && EntityUtil.isMeleeDamage(event.getSource())) {
                event.getSource().func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)plData.player()), event.getAmount() * (float)slots.size() / 4.0f);
                plData.player().field_71071_by.func_70449_g(event.getAmount() * 0.5f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystallisArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystallisArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystallisArmour.desc.3", Enums.ItemDescriptionType.POSITIVE));
    }
}

