/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.immersiveengineering;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.tslat.aoa3.block.functional.crops.CropBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.FluidsRegister;

public class IECompat {
    public static void init() {
        IECompat.registerPlantHandlers();
        ChemthrowerHandler.registerEffect((Fluid)FluidsRegister.CANDIED_WATER, (ChemthrowerHandler.ChemthrowerEffect)new ChemThrowerEffectCandiedWater());
    }

    private static void registerPlantHandlers() {
        IECompat.registerPlantHandler(BlockRegister.BUBBLE_BERRY_CROP);
        IECompat.registerPlantHandler(BlockRegister.EYE_BULB_CROP);
        IECompat.registerPlantHandler(BlockRegister.FLORACLES_CROP);
        IECompat.registerPlantHandler(BlockRegister.GOLDICAPS_CROP);
        IECompat.registerPlantHandler(BlockRegister.HEART_FRUIT_CROP);
        IECompat.registerPlantHandler(BlockRegister.HOLLY_TOPS_CROP);
        IECompat.registerPlantHandler(BlockRegister.LUNACRIKE_CROP);
        IECompat.registerPlantHandler(BlockRegister.LUNALON_CROP);
        IECompat.registerPlantHandler(BlockRegister.LUNA_GLOBE_CROP);
        IECompat.registerPlantHandler(BlockRegister.MAGIC_MARANG_CROP);
        IECompat.registerPlantHandler(BlockRegister.MYSTIC_SHROOM_CROP);
        IECompat.registerPlantHandler(BlockRegister.ROSIDON_CROP);
        IECompat.registerPlantHandler(BlockRegister.TEA_CROP);
        IECompat.registerPlantHandler(BlockRegister.THORNY_PLANT_CROP);
        IECompat.registerPlantHandler(BlockRegister.TRILLIAD_CROP);
    }

    private static void registerPlantHandler(final CropBlock crop) {
        final IBlockState cropBlockState = crop.func_176223_P();
        final ItemStack[] outputStacks = new ItemStack[]{new ItemStack(crop.func_149865_P()), new ItemStack((Item)crop.getSeeds(), 1)};
        BelljarHandler.DefaultPlantHandler plantHandler = new BelljarHandler.DefaultPlantHandler(){
            private final Item seed;
            private final HashSet<ComparableItemStack> seeds;
            {
                this.seed = (Item)crop.getSeeds();
                this.seeds = new HashSet(1);
            }

            protected HashSet<ComparableItemStack> getSeedSet() {
                return this.seeds;
            }

            public boolean isValid(ItemStack seed) {
                return seed.func_77973_b() == this.seed;
            }

            public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
                return Block.func_149634_a((Item)soil.func_77973_b()) == Blocks.field_150346_d;
            }

            public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return new IBlockState[]{cropBlockState.func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(Math.min(7, Math.round(7.0f * growth))))};
            }

            public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
                return outputStacks;
            }
        };
        BelljarHandler.registerHandler((BelljarHandler.IPlantHandler)plantHandler);
    }

    private static class ChemThrowerEffectCandiedWater
    extends ChemthrowerHandler.ChemthrowerEffect {
        private ChemThrowerEffectCandiedWater() {
        }

        public void applyToEntity(EntityLivingBase target, @Nullable EntityPlayer entityPlayer, ItemStack itemStack, Fluid fluid) {
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if ((target instanceof EntityBlaze || target instanceof EntityEnderman) && target.func_70097_a(entityPlayer == null ? DamageSource.field_76369_e : new EntityDamageSource(DamageSource.field_76369_e.func_76355_l(), (Entity)entityPlayer).func_76348_h(), 3.0f)) {
                target.field_70172_ad = (int)((double)target.field_70172_ad * 0.75);
            }
            if (target.func_70681_au().nextFloat() <= 0.5f) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20));
            }
        }

        public void applyToBlock(World world, RayTraceResult rayTraceResult, @Nullable EntityPlayer entityPlayer, ItemStack itemStack, Fluid fluid) {
            BlockPos pos = rayTraceResult.func_178782_a().func_177972_a(rayTraceResult.field_178784_b);
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block instanceof BlockFire) {
                world.func_175698_g(pos);
            }
        }
    }
}

