/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.crafttweaker.util;

import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.aoa3.PlayerData")
public class CTPlayerData {
    private PlayerDataManager plData;
    private final UUID backupPlayerUUID;

    public CTPlayerData(PlayerDataManager plData) {
        this.plData = plData;
        this.backupPlayerUUID = plData.player().func_110124_au();
    }

    @Nullable
    public static CTPlayerData getForPlayer(IPlayer player) {
        if (player.getInternal() == null || ModUtil.isClient()) {
            return null;
        }
        return new CTPlayerData(PlayerUtil.getAdventPlayer((EntityPlayer)player.getInternal()));
    }

    @ZenMethod
    public int getLevel(String skillName, @Optional boolean ignoreLevelCap) {
        if (!this.validatePlayerData()) {
            return 0;
        }
        Enums.Skills skill = Enums.Skills.fromString(skillName);
        if (skill == null) {
            return -1;
        }
        return ignoreLevelCap ? this.plData.stats().getLevelForDisplay(skill) : this.plData.stats().getLevel(skill);
    }

    @ZenMethod
    public float getXp(String skillName) {
        if (!this.validatePlayerData()) {
            return 0.0f;
        }
        Enums.Skills skill = Enums.Skills.fromString(skillName);
        if (skill == null) {
            return -1.0f;
        }
        return this.plData.stats().getExp(skill);
    }

    @ZenMethod
    public void grantXp(String skillName, float xpAmount) {
        if (!this.validatePlayerData()) {
            return;
        }
        Enums.Skills skill = Enums.Skills.fromString(skillName);
        if (skill != null) {
            this.plData.stats().addXp(skill, xpAmount, false, false);
        }
    }

    @ZenMethod
    public float getResourceValue(String resourceName) {
        if (!this.validatePlayerData()) {
            return -1.0f;
        }
        Enums.Resources resource = Enums.Resources.fromString(resourceName);
        if (resource != null) {
            return this.plData.stats().getResourceValue(resource);
        }
        return -1.0f;
    }

    @ZenMethod
    public void grantResource(String resourceName, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        Enums.Resources resource = Enums.Resources.fromString(resourceName);
        if (resource != null) {
            this.plData.stats().regenResource(resource, amount);
        }
    }

    @ZenMethod
    public int getTribute(String deityName) {
        if (!this.validatePlayerData()) {
            return -1;
        }
        Enums.Deities deity = Enums.Deities.fromString(deityName);
        if (deity != null) {
            return this.plData.stats().getTribute(deity);
        }
        return -1;
    }

    @ZenMethod
    public boolean consumeResource(String resourceName, float amount, boolean forceConsume) {
        if (!this.validatePlayerData()) {
            return false;
        }
        Enums.Resources resource = Enums.Resources.fromString(resourceName);
        if (resource != null) {
            return this.plData.stats().consumeResource(resource, amount, forceConsume);
        }
        return false;
    }

    @ZenMethod
    public void grantTribute(String deityName, int amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        Enums.Deities deity = Enums.Deities.fromString(deityName);
        if (deity != null) {
            this.plData.stats().addTribute(deity, amount);
        }
    }

    @ZenMethod
    public void resetTributes() {
        this.plData.stats().resetAllTribute();
    }

    @ZenMethod
    public float getGlobalXpModifier() {
        if (!this.validatePlayerData()) {
            return -1.0f;
        }
        return this.plData.buffs().getGlobalXpModifier();
    }

    @ZenMethod
    public void addGlobalXpModifier(float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        this.plData.buffs().addGlobalXpModifier(amount);
    }

    @ZenMethod
    public void removeGlobalXpModifier(float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        this.plData.buffs().removeGlobalXpModifier(amount);
    }

    @ZenMethod
    public void addSkillXpModifier(String skillName, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        Enums.Skills skill = Enums.Skills.fromString(skillName);
        if (skill != null) {
            this.plData.buffs().addXpModifier(skill, amount);
        }
    }

    @ZenMethod
    public void removeSkillXpModifier(String skillName, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        Enums.Skills skill = Enums.Skills.fromString(skillName);
        if (skill != null) {
            this.plData.buffs().removeXpModifier(skill, amount);
        }
    }

    @ZenGetter
    public IItemStack getArmourSetType() {
        if (!this.validatePlayerData()) {
            return MCItemStack.EMPTY;
        }
        if (this.plData.equipment().getCurrentFullArmourSet() == null) {
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(new ItemStack(this.plData.player().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b()));
    }

    private boolean validatePlayerData() {
        if (this.plData == null || this.plData.player() == null || this.plData.player().field_70128_L) {
            if (this.backupPlayerUUID == null) {
                return false;
            }
            EntityPlayerMP pl = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.backupPlayerUUID);
            if (pl == null) {
                return false;
            }
            this.plData = PlayerUtil.getAdventPlayer((EntityPlayer)pl);
        }
        return true;
    }
}

