/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.crafttweaker.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import net.tslat.aoa3.utils.ItemUtil;
import org.apache.logging.log4j.Level;
import scala.actors.threadpool.Arrays;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.aoa3.InfusionTable")
public class CTInfusionTable {
    @ZenMethod
    public static void addInfusionRecipe(String id, IItemStack input, IItemStack output, IIngredient[] infusionIngredients, @Optional(valueLong=1L) long infusionLevelReq, @Optional int minXp, @Optional int maxXp) {
        ItemStack targetStack = CraftTweakerMC.getItemStack((IItemStack)input);
        ItemStack outputStack = CraftTweakerMC.getItemStack((IItemStack)output);
        NonNullList ingredients = NonNullList.func_191196_a();
        for (IIngredient ing : infusionIngredients) {
            if (ingredients.size() >= 9) {
                AdventOfAscension.logOptionalMessage("Too many ingredients entered for CraftTweaker infusion recipe: " + id + ". Truncating ingredients.");
                break;
            }
            ingredients.add((Object)CraftTweakerMC.getIngredient((IIngredient)ing));
        }
        minXp = Math.max(0, minXp);
        maxXp = Math.max(minXp, maxXp);
        InfusionTableRecipe recipe = new InfusionTableRecipe("", targetStack, outputStack, (NonNullList<Ingredient>)ingredients, (int)infusionLevelReq, minXp, maxXp);
        CraftTweakerAPI.apply((IAction)new AddInfusionRecipe(recipe, id));
    }

    @ZenMethod
    public static void addImbuingRecipe(String id, IItemStack input, IIngredient[] imbuingIngredients, String enchantmentId, @Optional(valueLong=1L) long enchantmentLevel, @Optional(valueLong=1L) long infusionLevelReq, @Optional int minXp, @Optional int maxXp) {
        ItemStack targetStack = CraftTweakerMC.getItemStack((IItemStack)input);
        NonNullList ingredients = NonNullList.func_191196_a();
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentId));
        if (enchantment == null) {
            AdventOfAscension.logMessage(Level.WARN, "Invalid enchantment ID: " + enchantmentId + " from CraftTweaker recipe " + id);
            return;
        }
        for (IIngredient ing : imbuingIngredients) {
            if (ingredients.size() >= 9) {
                AdventOfAscension.logOptionalMessage("Too many ingredients entered for CraftTweaker infusion recipe: " + id + ". Truncating ingredients.");
                break;
            }
            ingredients.add((Object)CraftTweakerMC.getIngredient((IIngredient)ing));
        }
        minXp = Math.max(0, minXp);
        maxXp = Math.max(minXp, maxXp);
        InfusionTableRecipe recipe = new InfusionTableRecipe("", enchantment, (int)enchantmentLevel, (NonNullList<Ingredient>)ingredients, (int)infusionLevelReq, minXp, maxXp);
        CraftTweakerAPI.apply((IAction)new AddInfusionRecipe(recipe, id));
    }

    @ZenMethod
    public static void removeInfusionRecipe(String resourcePath) {
        if (!resourcePath.contains(":")) {
            resourcePath = "aoa3:" + resourcePath;
        }
        CraftTweakerAPI.apply((IAction)new RemoveInfusionRecipe(new ResourceLocation[]{new ResourceLocation(resourcePath)}));
    }

    @ZenMethod
    public static void removeImbuingRecipe(String enchantmentId, int enchantmentLevel) {
        Enchantment enchant = Enchantment.func_180305_b((String)enchantmentId);
        if (enchant == null) {
            AdventOfAscension.logMessage(Level.WARN, "Invalid enchantment ID provided by CraftTweaker integration: " + enchantmentId);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveInfusionRecipe(new EnchantmentData(enchant, enchantmentLevel)));
    }

    @ZenMethod
    public static void removeInfusionRecipe(IItemStack outputStack) {
        CraftTweakerAPI.apply((IAction)new RemoveInfusionRecipe(CraftTweakerMC.getItemStack((IItemStack)outputStack)));
    }

    private static class AddInfusionRecipe
    implements IAction {
        private final InfusionTableRecipe recipe;
        private final String recipeId;

        private AddInfusionRecipe(@Nonnull InfusionTableRecipe recipe, String id) {
            this.recipe = recipe;
            this.recipeId = id;
        }

        public void apply() {
            ForgeRegistries.RECIPES.register(this.recipe.setRegistryName(new ResourceLocation("aoa3_ct", this.recipeId)));
        }

        public String describe() {
            if (this.recipe.isEnchanting()) {
                return "Registering Imbuing recipe for " + this.recipe.getEnchantmentAsBook().func_82833_r() + ". Recipe ID: " + this.recipeId;
            }
            return "Registering Infusion recipe for " + this.recipe.func_77571_b().func_82833_r() + ". Recipe ID: " + this.recipeId;
        }
    }

    private static class RemoveInfusionRecipe
    extends MCRecipeManager.ActionBaseRemoveRecipes {
        @Nullable
        private final ResourceLocation[] recipeIds;
        @Nullable
        private final EnchantmentData enchant;
        @Nullable
        private final ItemStack outputStack;

        private RemoveInfusionRecipe(ResourceLocation ... recipeIds) {
            this.recipeIds = recipeIds;
            this.enchant = null;
            this.outputStack = null;
        }

        private RemoveInfusionRecipe(EnchantmentData enchData) {
            this.enchant = enchData;
            this.recipeIds = null;
            this.outputStack = null;
        }

        private RemoveInfusionRecipe(ItemStack outputStack) {
            this.enchant = null;
            this.recipeIds = null;
            this.outputStack = outputStack;
        }

        public void apply() {
            if (this.recipeIds != null) {
                this.removeRecipes(Arrays.asList((Object[])this.recipeIds));
            } else if (this.enchant != null) {
                ArrayList<ResourceLocation> matchedRecipes = new ArrayList<ResourceLocation>();
                for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                    EnchantmentData data;
                    InfusionTableRecipe infusion;
                    if (!(recipe instanceof InfusionTableRecipe) || !(infusion = (InfusionTableRecipe)recipe).isEnchanting() || (data = infusion.getEnchantment()) == null || data.field_76302_b != this.enchant.field_76302_b || data.field_76303_c != this.enchant.field_76303_c) continue;
                    matchedRecipes.add(recipe.getRegistryName());
                }
                this.removeRecipes(matchedRecipes);
            } else {
                ArrayList<ResourceLocation> matchedRecipes = new ArrayList<ResourceLocation>();
                for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                    if (!(recipe instanceof InfusionTableRecipe) || !ItemUtil.areStacksFunctionallyEqual(recipe.func_77571_b(), this.outputStack)) continue;
                    matchedRecipes.add(recipe.getRegistryName());
                }
                this.removeRecipes(matchedRecipes);
            }
        }

        public String describe() {
            if (this.recipeIds != null) {
                return "Removing " + this.recipeIds.length + " recipes from the Infusion Table registry.";
            }
            if (this.outputStack != null) {
                return "Removing all Infusion Table recipes resulting in " + this.outputStack.func_82833_r() + ".";
            }
            return "Removing all Infusion Table recipes for " + this.enchant.field_76302_b.func_77316_c(this.enchant.field_76303_c);
        }
    }
}

