/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dimension;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.EntitySpawnRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class OverworldEvents {
    private static final Random eventRand = new Random();
    private static long lastWorldCheckTime = 0L;
    private static final HashSet<Enums.CreatureEvents> events = new HashSet(Enums.CreatureEvents.values().length);

    public static void doTickCheck(TickEvent.WorldTickEvent ev) {
        if (ev.world.func_82737_E() <= 24000L) {
            return;
        }
        int time = (int)(ev.world.func_72820_D() % 24000L);
        switch (time) {
            case 480: {
                if (!ConfigurationUtil.MainConfig.overworldEvents.enabled) break;
                eventRand.setSeed(ev.world.func_72905_C() + ev.world.func_82737_E());
                if (ConfigurationUtil.MainConfig.overworldEvents.bigDayChance > 0 && eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.bigDayChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.BIG_DAY);
                }
                if (ConfigurationUtil.MainConfig.overworldEvents.creepDayChance > 0 && eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.creepDayChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.CREEP_DAY);
                }
                if (ConfigurationUtil.MainConfig.overworldEvents.deathDayChance <= 0 || eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.deathDayChance) != 0) break;
                OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.DEATH_DAY);
                break;
            }
            case 12500: {
                for (EntityPlayer pl : ev.world.field_73010_i) {
                    PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                    boolean tributed = false;
                    int luxon = plData.stats().getTribute(Enums.Deities.LUXON);
                    int selyan = plData.stats().getTribute(Enums.Deities.SELYAN);
                    int pluton = plData.stats().getTribute(Enums.Deities.PLUTON);
                    int erebon = plData.stats().getTribute(Enums.Deities.EREBON);
                    if (ConfigurationUtil.MainConfig.showDailyMessages) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.nightfall", TextFormatting.DARK_AQUA));
                    }
                    if (pluton == 200) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.pluton", TextFormatting.GOLD));
                        tributed = true;
                    }
                    if (luxon == 200) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.luxon", TextFormatting.AQUA));
                        tributed = true;
                    }
                    if (selyan == 200) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.selyan", TextFormatting.GREEN));
                        tributed = true;
                    }
                    if (erebon == 200) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.erebon", TextFormatting.DARK_RED));
                        tributed = true;
                    }
                    if (pluton >= 100 && luxon >= 100 && erebon >= 100 && selyan >= 100) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.krasaun", TextFormatting.LIGHT_PURPLE));
                        pl.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 6000, 0, true, false));
                        tributed = true;
                        if (pluton == 200 && luxon == 200 && erebon == 200 && selyan == 200) {
                            ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((Item)WeaponRegister.HOLY_SWORD));
                        }
                    }
                    if (tributed) {
                        ev.world.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, SoundsRegister.TRIBUTE_SUCCESS, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        continue;
                    }
                    if (ConfigurationUtil.MainConfig.showDailyMessages) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.tribute.none." + AdventOfAscension.rand.nextInt(10), TextFormatting.DARK_GRAY));
                    }
                    ev.world.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, SoundsRegister.TRIBUTE_FAIL, SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
                break;
            }
            case 12600: {
                if (!ConfigurationUtil.MainConfig.overworldEvents.enabled) break;
                eventRand.setSeed(ev.world.func_72905_C() + ev.world.func_82737_E());
                if (ConfigurationUtil.MainConfig.overworldEvents.soulScurryChance > 0 && eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.soulScurryChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.SOUL_SCURRY);
                }
                if (ConfigurationUtil.MainConfig.overworldEvents.bloodHuntChance > 0 && eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.bloodHuntChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.BLOOD_HUNT);
                }
                if (ConfigurationUtil.MainConfig.overworldEvents.lunarInvasionChance > 0 && eventRand.nextInt(ConfigurationUtil.MainConfig.overworldEvents.lunarInvasionChance) == 0) {
                    OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.LUNAR_INVASION);
                }
                if (!ConfigurationUtil.MainConfig.overworldEvents.fullMoonEnabled || ev.world.func_130001_d() != 1.0f) break;
                OverworldEvents.activateEvent(ev.world, Enums.CreatureEvents.FULL_MOON);
                break;
            }
            case 12000: 
            case 12020: 
            case 12040: 
            case 13005: {
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.BIG_DAY);
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.CREEP_DAY);
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.DEATH_DAY);
                break;
            }
            case 23031: {
                for (EntityPlayer pl : ev.world.field_73010_i) {
                    if (ConfigurationUtil.MainConfig.showDailyMessages) {
                        pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.event.sunrise", TextFormatting.YELLOW));
                    }
                    PlayerUtil.getAdventPlayer(pl).stats().resetAllTribute();
                }
                break;
            }
            case 5: 
            case 1005: 
            case 23060: 
            case 23080: 
            case 23100: {
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.SOUL_SCURRY);
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.BLOOD_HUNT);
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.LUNAR_INVASION);
                OverworldEvents.deactivateEvent(ev.world, Enums.CreatureEvents.FULL_MOON);
                break;
            }
        }
    }

    public static void activateEvent(World world, @Nonnull Enums.CreatureEvents event) {
        if (!events.contains((Object)event)) {
            events.add(event);
            EntitySpawnRegister.addEventSpawns(event);
            ITextComponent message = OverworldEvents.getEventMessage(event, false);
            SoundEvent sound = null;
            switch (event) {
                case BIG_DAY: {
                    sound = SoundsRegister.BIG_DAY_START;
                    break;
                }
                case BLOOD_HUNT: {
                    sound = SoundsRegister.BLOOD_HUNT_START;
                    break;
                }
                case CREEP_DAY: {
                    sound = SoundsRegister.CREEP_DAY_START;
                    break;
                }
                case DEATH_DAY: {
                    sound = SoundsRegister.DEATH_DAY_START;
                    break;
                }
                case FULL_MOON: {
                    break;
                }
                case LUNAR_INVASION: {
                    sound = SoundsRegister.LUNAR_INVASION_START;
                    break;
                }
                case SOUL_SCURRY: {
                    sound = SoundsRegister.SOUL_SCURRY_START;
                }
            }
            for (EntityPlayer pl : world.field_73010_i) {
                pl.func_145747_a(message);
                if (sound == null) continue;
                world.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, sound, SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private static ITextComponent getEventMessage(Enums.CreatureEvents event, boolean isEnding) {
        switch (event) {
            case BIG_DAY: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".bigDay", TextFormatting.GOLD);
            }
            case BLOOD_HUNT: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".bloodHunt", TextFormatting.DARK_RED);
            }
            case CREEP_DAY: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".creepDay", TextFormatting.GREEN);
            }
            case DEATH_DAY: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".deathDay", TextFormatting.RED);
            }
            case FULL_MOON: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".fullMoon", TextFormatting.GRAY);
            }
            case LUNAR_INVASION: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".lunarInvasion", TextFormatting.LIGHT_PURPLE);
            }
            case SOUL_SCURRY: {
                return StringUtil.getColourLocale("message.event." + (isEnding ? "end" : "start") + ".soulScurry", TextFormatting.AQUA);
            }
        }
        return null;
    }

    public static void deactivateEvent(World world, @Nonnull Enums.CreatureEvents event) {
        if (events.contains((Object)event)) {
            events.remove((Object)event);
            EntitySpawnRegister.removeEventSpawns(event);
            ITextComponent message = OverworldEvents.getEventMessage(event, true);
            for (EntityPlayer pl : world.field_73010_i) {
                pl.func_145747_a(message);
            }
        }
    }

    public static boolean isEventActive(@Nonnull Enums.CreatureEvents event) {
        return events.contains((Object)event);
    }

    public static void doWorldStartCheck(World world) {
        if (lastWorldCheckTime >= world.func_72820_D() - 10L) {
            return;
        }
        events.clear();
        int time = (int)(world.func_72820_D() % 24000L);
        if (time < 23000) {
            if (time >= 12600) {
                long remainder = time - 12600;
                eventRand.setSeed(world.func_72905_C() + (world.func_82737_E() - remainder));
                if (eventRand.nextInt(15) == 0) {
                    events.add(Enums.CreatureEvents.SOUL_SCURRY);
                }
                if (eventRand.nextInt(18) == 0) {
                    events.add(Enums.CreatureEvents.BLOOD_HUNT);
                }
                if (eventRand.nextInt(22) == 0) {
                    events.add(Enums.CreatureEvents.LUNAR_INVASION);
                }
                if (world.func_130001_d() == 1.0f) {
                    events.add(Enums.CreatureEvents.FULL_MOON);
                }
            } else if (time >= 480) {
                long remainder = time - 480;
                eventRand.setSeed(world.func_72905_C() + (world.func_82737_E() - remainder));
                if (eventRand.nextInt(26) == 0) {
                    events.add(Enums.CreatureEvents.BIG_DAY);
                }
                if (eventRand.nextInt(30) == 0) {
                    events.add(Enums.CreatureEvents.CREEP_DAY);
                }
                if (eventRand.nextInt(25) == 0) {
                    events.add(Enums.CreatureEvents.DEATH_DAY);
                }
            }
        }
        lastWorldCheckTime = world.func_72820_D();
    }

    public static void alertNewPlayer(World world, EntityPlayer player) {
        for (Enums.CreatureEvents event : events) {
            player.func_145747_a(OverworldEvents.getEventMessage(event, false));
        }
    }
}

