/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.npcs.trader.EntityAssassin;
import net.tslat.aoa3.entity.npcs.trader.EntityNaturalist;
import net.tslat.aoa3.entity.npcs.trader.EntityRealmshifter;
import net.tslat.aoa3.entity.npcs.trader.EntityTrollTrader;
import net.tslat.aoa3.entity.npcs.trader.EntityUndeadHerald;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class WorldEvents {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END || ev.world.field_72995_K) {
            return;
        }
        int dim = ev.world.field_73011_w.getDimension();
        if (dim == 0) {
            OverworldEvents.doTickCheck(ev);
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Post ev) {
        if (ev.isHasVillageGenerated()) {
            int posY;
            int posZ;
            int posX;
            Random rand = ev.getRand();
            World world = ev.getWorld();
            if (ConfigurationUtil.StructureConfig.overworld.ruinedTeleporterFrameSpawnChance > 0 && rand.nextInt((int)Math.ceil((float)ConfigurationUtil.StructureConfig.overworld.ruinedTeleporterFrameSpawnChance / 8.0f)) == 0) {
                posX = ev.getChunkX() + rand.nextInt(16);
                posZ = ev.getChunkZ() + rand.nextInt(15);
                posY = rand.nextInt(10) + 10;
                Block centerBlock = world.func_180495_p(new BlockPos(posX + 5, posY, posZ + 7)).func_177230_c();
                if (centerBlock != Blocks.field_150350_a && centerBlock != BlockRegister.ANCIENT_ROCK) {
                    StructuresHandler.generateStructure("RuinedTeleporterFrame", world, rand, new BlockPos(posX, posY, posZ));
                }
            }
            if (rand.nextInt(20) == 0) {
                AoATrader trader;
                posX = ev.getChunkX() + rand.nextInt(16);
                posZ = ev.getChunkZ() + rand.nextInt(15);
                posY = ev.getWorld().func_189649_b(posX, posZ);
                switch (rand.nextInt(1)) {
                    case 0: {
                        trader = new EntityAssassin(world);
                        break;
                    }
                    case 1: {
                        trader = new EntityNaturalist(world);
                        break;
                    }
                    case 2: {
                        trader = new EntityRealmshifter(world);
                        break;
                    }
                    case 3: {
                        trader = new EntityTrollTrader(world);
                        break;
                    }
                    default: {
                        trader = new EntityUndeadHerald(world);
                    }
                }
                trader.func_70107_b(posX, posY, posZ);
                ev.getWorld().func_72838_d((Entity)trader);
            }
        }
    }
}

