/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.mob;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.boss.corallus.EntityCorallus;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityCorallusShot
extends EntityFlying {
    private final EntityCorallus corallus;
    private final EntityLivingBase target;
    private final float dmg;

    public EntityCorallusShot(EntityCorallus corallus, EntityLivingBase target, int dmg) {
        super(corallus.field_70170_p);
        this.corallus = corallus;
        this.target = target;
        this.dmg = dmg;
        this.func_70105_a(1.1f, 1.1f);
        this.field_70178_ae = true;
        this.func_189654_d(true);
    }

    public EntityCorallusShot(World world) {
        super(world);
        this.corallus = null;
        this.target = null;
        this.dmg = 0.0f;
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityCorallusShotAI(this));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_145773_az() {
        return true;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.CORAL_STAFF_CAST;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            WorldUtil.createExplosion((Entity)this.corallus, this.field_70170_p, (Entity)this, 1.0f);
            this.func_70106_y();
        }
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && entityIn == this.target) {
            this.target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.dmg);
            WorldUtil.createExplosion((Entity)this.corallus, this.field_70170_p, (Entity)this, 1.0f);
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    private class EntityCorallusShotAI
    extends EntityAIBase {
        private final EntityCorallusShot shot;

        public EntityCorallusShotAI(EntityCorallusShot shot) {
            this.shot = shot;
        }

        public boolean func_75252_g() {
            return false;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75249_e() {
            if (!(EntityCorallusShot.this.field_70170_p.field_72995_K || this.shot.target != null && this.shot.target.func_70089_S())) {
                EntityCorallusShot.this.func_70106_y();
            }
        }

        public boolean func_75253_b() {
            return true;
        }

        public void func_75246_d() {
            if (this.shot.target == null || !this.shot.target.func_70089_S()) {
                if (!EntityCorallusShot.this.field_70170_p.field_72995_K) {
                    WorldUtil.createExplosion((Entity)EntityCorallusShot.this.corallus, EntityCorallusShot.this.field_70170_p, (Entity)this.shot, 1.0f);
                    EntityCorallusShot.this.func_70106_y();
                }
            } else {
                double distanceX = ((EntityCorallusShot)this.shot).target.field_70165_t - this.shot.field_70165_t;
                double distanceY = ((EntityCorallusShot)this.shot).target.field_70163_u - this.shot.field_70163_u;
                double distanceZ = ((EntityCorallusShot)this.shot).target.field_70161_v - this.shot.field_70161_v;
                if (Math.signum(distanceX) != 0.0 || Math.signum(distanceY) != 0.0 || Math.signum(distanceZ) != 0.0) {
                    this.shot.field_70159_w += (Math.signum(distanceX) * 0.3 - this.shot.field_70159_w) * (double)0.1f;
                    this.shot.field_70181_x += (Math.signum(distanceY) * 0.3 - this.shot.field_70181_x) * (double)0.1f;
                    this.shot.field_70179_y += (Math.signum(distanceZ) * 0.3 - this.shot.field_70179_y) * (double)0.1f;
                    this.shot.field_70177_z += MathHelper.func_76142_g((float)((float)(Math.atan2(this.shot.field_70179_y, this.shot.field_70159_w) * 180.0 / Math.PI) - 90.0f - this.shot.field_70177_z));
                }
            }
        }
    }
}

