/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.mob;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.library.Enums;

public abstract class BaseMobProjectile
extends EntityThrowable {
    private Enums.MobProjectileType projectileType;
    private AoARangedAttacker shooter;

    public BaseMobProjectile(World world) {
        super(world);
    }

    public BaseMobProjectile(World world, AoARangedAttacker shooter, double posX, double posY, double posZ, Enums.MobProjectileType projectileType) {
        super(world);
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = this.field_70146_Z.nextGaussian() / 33.0 + 0.03;
        this.field_70181_x = -2.0;
        this.field_70179_y = this.field_70146_Z.nextGaussian() / 33.0 + 0.03;
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public BaseMobProjectile(World world, AoARangedAttacker shooter, Entity target, Enums.MobProjectileType projectileType) {
        this(world, shooter, target.field_70165_t, target.field_70163_u + 25.0, target.field_70161_v, projectileType);
    }

    public BaseMobProjectile(World world, AoARangedAttacker shooter, Enums.MobProjectileType projectileType) {
        super(world);
        if (shooter instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)shooter;
            this.func_70107_b(this.field_70192_c.field_70165_t, this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e() - (double)0.1f, this.field_70192_c.field_70161_v);
        }
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public Enums.MobProjectileType getProjectileType() {
        return this.projectileType;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 500) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if ((result.field_72313_a != RayTraceResult.Type.BLOCK || this.field_70170_p.func_180495_p(result.func_178782_a()).func_185904_a().func_76230_c()) && !this.field_70170_p.field_72995_K) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (result.field_72308_g == this.shooter || this.shooter == null) {
                    return;
                }
                this.shooter.doProjectileEntityImpact(this, result.field_72308_g);
            } else if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.shooter != null) {
                this.shooter.doProjectileBlockImpact(this, this.field_70170_p.func_180495_p(result.func_178782_a()), result.func_178782_a(), result.field_178784_b);
            }
            this.func_70106_y();
        }
    }

    public boolean func_180427_aV() {
        return true;
    }
}

