/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.entity.projectiles.HardProjectile;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.WorldUtil;

public class BaseBullet
extends EntityThrowable
implements HardProjectile {
    private float dmgMulti;
    private int lifespan;
    private int pierceCount;
    private int age = 0;
    private BaseGun weapon;
    private Entity lastPierceTarget;
    private EnumHand hand;

    public BaseBullet(World world) {
        super(world);
    }

    public BaseBullet(EntityLivingBase shooter, BaseGun gun, float dmgMultiplier, int piercingValue, float velocity) {
        super(shooter.field_70170_p);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = 60;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.hand = EnumHand.MAIN_HAND;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        float vectorX = -MathHelper.func_76126_a((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        float vectorY = -MathHelper.func_76126_a((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        float vectorZ = MathHelper.func_76134_b((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        this.func_70186_c(vectorX, vectorY, vectorZ, velocity, 0.0f);
    }

    public BaseBullet(EntityLivingBase shooter, BaseGun gun, EnumHand hand, int maxAge, float dmgMultiplier, int piercingValue, float xMod, float yMod, float zMod) {
        super(shooter.field_70170_p);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof EntityPlayer) {
            if (hand == EnumHand.MAIN_HAND) {
                if (shooter.func_184591_cq() == EnumHandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == EnumHandSide.RIGHT) {
                right = false;
            }
        }
        if (right) {
            this.func_70107_b(this.field_70165_t - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.field_70165_t + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) + xMod, -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) + yMod, MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) + zMod, 3.0f, 2.0f);
        this.field_70165_t += this.field_70159_w * 0.5;
        this.field_70163_u += this.field_70181_x * 0.5;
        this.field_70161_v += this.field_70179_y * 0.5;
    }

    public BaseBullet(EntityLivingBase shooter, BaseGun gun, EnumHand hand, int maxAge, float dmgMultiplier, int piercingValue) {
        super(shooter.field_70170_p);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof EntityPlayer) {
            if (hand == EnumHand.MAIN_HAND) {
                if (shooter.func_184591_cq() == EnumHandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == EnumHandSide.RIGHT) {
                right = false;
            }
        }
        if (right) {
            this.func_70107_b(this.field_70165_t - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.field_70165_t + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), 3.0f, 2.0f);
        this.field_70165_t += this.field_70159_w * 0.5;
        this.field_70163_u += this.field_70181_x * 0.5;
        this.field_70161_v += this.field_70179_y * 0.5;
    }

    public BaseBullet(World world, double x, double y, double z) {
        super(world);
        this.lifespan = 60;
        this.func_70107_b(x, y, z);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            float hardness;
            IBlockState bl = this.field_70170_p.func_180495_p(result.func_178782_a());
            if (WorldUtil.checkGameRule(this.field_70170_p, "destructiveWeaponPhysics") && (hardness = bl.func_185887_b(this.field_70170_p, result.func_178782_a())) >= 0.0f && hardness <= 0.3f) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.field_70170_p.func_175655_b(result.func_178782_a(), true);
                } else {
                    this.field_70170_p.func_175698_g(result.func_178782_a());
                }
                if (this.field_70146_Z.nextFloat() > hardness / 1.5f) {
                    return;
                }
            }
            if (!bl.func_185904_a().func_76230_c()) {
                return;
            }
            this.doImpactEffect();
        } else {
            if (result.field_72308_g != this.lastPierceTarget) {
                if (this.weapon == null) {
                    this.doEntityImpact(result.field_72308_g);
                } else {
                    this.weapon.doImpactDamage(result.field_72308_g, this.func_85052_h(), this, this.dmgMulti);
                }
                this.doImpactEffect();
                --this.pierceCount;
            }
            if (this.pierceCount >= 0) {
                this.lastPierceTarget = result.field_72308_g;
                return;
            }
        }
        this.func_70106_y();
    }

    public void doEntityImpact(Entity target) {
    }

    @Override
    public void doImpactEffect() {
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_174854_a || this.age > this.lifespan) {
                this.func_70106_y();
                return;
            }
            ++this.age;
        }
        Vec3d position = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d velocityAdjustedPosition = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult intersectedBlocksTrace = this.field_70170_p.func_72933_a(position, velocityAdjustedPosition);
        position = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        velocityAdjustedPosition = intersectedBlocksTrace != null ? new Vec3d(intersectedBlocksTrace.field_72307_f.field_72450_a, intersectedBlocksTrace.field_72307_f.field_72448_b, intersectedBlocksTrace.field_72307_f.field_72449_c) : new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        Entity impactEntity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(0.5));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            RayTraceResult interceptTrace;
            Entity collidedEntity = (Entity)list.get(i);
            if (!collidedEntity.func_70067_L() || collidedEntity == this.field_184539_c || (interceptTrace = collidedEntity.func_174813_aQ().func_186662_g((double)0.3f).func_72327_a(position, velocityAdjustedPosition)) == null || !((d1 = position.func_72436_e(interceptTrace.field_72307_f)) < d0) && d0 != 0.0) continue;
            impactEntity = collidedEntity;
            d0 = d1;
        }
        if (impactEntity != null) {
            intersectedBlocksTrace = new RayTraceResult(impactEntity);
        }
        if (intersectedBlocksTrace != null && !ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)intersectedBlocksTrace)) {
            this.func_70184_a(intersectedBlocksTrace);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float dragValue = 0.99f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            dragValue = 0.8f;
        }
        this.field_70159_w *= (double)dragValue;
        this.field_70181_x *= (double)dragValue;
        this.field_70179_y *= (double)dragValue;
        this.field_70181_x -= (double)this.func_70185_h();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public BaseBullet setMaxAge(int maxAge) {
        this.lifespan = maxAge;
        return this;
    }

    public BaseBullet setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    @Nullable
    public BaseGun getWeapon() {
        return this.weapon;
    }
}

