/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.passive;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAAnimal;
import net.tslat.aoa3.entity.base.ai.RoamingFlightMoveHelper;
import net.tslat.aoa3.entity.base.ai.mob.EntityAILookAround;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIRandomFly;

public class EntityMeganeuropsis
extends AoAAnimal
implements EntityFlying {
    private static final DataParameter<Boolean> LANDED = EntityDataManager.func_187226_a(EntityMeganeuropsis.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> START_LANDING_TICKS = EntityDataManager.func_187226_a(EntityMeganeuropsis.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<EnumFacing> LANDING_DIRECTION = EntityDataManager.func_187226_a(EntityMeganeuropsis.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Optional<UUID>> LANDED_PLAYER = EntityDataManager.func_187226_a(EntityMeganeuropsis.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final float entityWidth = 0.5f;
    private EntityPlayer clientRidingPlayer = null;
    private int clientStartLandingTicks = 0;

    public EntityMeganeuropsis(World world) {
        super(world, 0.5f, 0.4375f);
        this.field_70765_h = new RoamingFlightMoveHelper((EntityLiving)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LANDED, (Object)false);
        this.field_70180_af.func_187214_a(START_LANDING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(LANDING_DIRECTION, (Object)EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(LANDED_PLAYER, (Object)Optional.absent());
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMeganeuropsisLand(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRandomFly((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookAround((EntityLiving)this));
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public float func_70047_e() {
        return 0.3125f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.5;
    }

    @Override
    protected double getBaseArmor() {
        return 4.0;
    }

    public int getStartLandingTicks() {
        return this.field_70170_p.field_72995_K ? this.clientStartLandingTicks : (Integer)this.field_70180_af.func_187225_a(START_LANDING_TICKS);
    }

    public boolean isLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(LANDED);
    }

    public EnumFacing getLandingDirection() {
        return (EnumFacing)this.field_70180_af.func_187225_a(LANDING_DIRECTION);
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsRegister.ENTITY_MEGANEUROPSIS_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.ENTITY_MEGANEUROPSIS_DEATH;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.ENTITY_MEGANEUROPSIS_LIVING;
    }

    @Override
    protected SoundEvent getStepSound() {
        return null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMeganeuropsis;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && key == START_LANDING_TICKS) {
            this.clientStartLandingTicks = this.field_70173_aa;
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.isLanded()) {
            EntityPlayer pl;
            if (this.field_70170_p.field_72995_K && this.getLandingDirection() == EnumFacing.DOWN && !this.func_184218_aH() && ((Optional)this.field_70180_af.func_187225_a(LANDED_PLAYER)).isPresent() && (pl = this.field_70170_p.func_152378_a((UUID)((Optional)this.field_70180_af.func_187225_a(LANDED_PLAYER)).get())) != null) {
                this.clientRidingPlayer = pl;
                this.func_184205_a((Entity)this.clientRidingPlayer, false);
            }
            return;
        }
        if (this.field_70170_p.field_72995_K && this.func_184218_aH() && this.clientRidingPlayer != null) {
            this.clientRidingPlayer = null;
            this.func_184210_p();
        }
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            IBlockState underState;
            BlockPos underPos;
            float friction = 0.91f;
            if (this.field_70122_E) {
                underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                underState = this.field_70170_p.func_180495_p(underPos);
                friction = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * (0.16277136f / (friction * friction * friction)) : 0.02f);
            friction = 0.91f;
            if (this.field_70122_E) {
                underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                underState = this.field_70170_p.func_180495_p(underPos);
                friction = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double movedX = this.field_70165_t - this.field_70169_q;
        double movedZ = this.field_70161_v - this.field_70166_s;
        float totalMotion = MathHelper.func_76133_a((double)(movedX * movedX + movedZ * movedZ)) * 4.0f;
        if (totalMotion > 1.0f) {
            totalMotion = 1.0f;
        }
        this.field_70721_aZ += (totalMotion - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    static /* synthetic */ PathNavigate access$200(EntityMeganeuropsis x0) {
        return x0.field_70699_by;
    }

    private class EntityAIMeganeuropsisLand
    extends EntityAIBase {
        private final EntityMeganeuropsis taskOwner;
        private BlockPos landingPos = null;
        private EnumFacing blockFace = null;
        private EntityPlayer landingPlayer = null;

        public EntityAIMeganeuropsisLand(EntityMeganeuropsis creature) {
            this.taskOwner = creature;
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            if (this.taskOwner.func_70643_av() != null) {
                return false;
            }
            if (this.landingPos == null && this.landingPlayer == null && this.taskOwner.func_70681_au().nextFloat() <= 0.01f) {
                if (EntityMeganeuropsis.this.field_70146_Z.nextBoolean()) {
                    EntityPlayer nearestPlayer = this.taskOwner.field_70170_p.func_184142_a((Entity)this.taskOwner, 10.0, 10.0);
                    if (nearestPlayer != null && !nearestPlayer.func_184207_aI()) {
                        this.taskOwner.field_70699_by.func_75499_g();
                        this.landingPlayer = nearestPlayer;
                        return true;
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        int z;
                        int x = (int)(this.taskOwner.field_70165_t + this.taskOwner.func_70681_au().nextGaussian() * 10.0);
                        int y = this.taskOwner.field_70170_p.func_189649_b(x, z = (int)(this.taskOwner.field_70161_v + this.taskOwner.func_70681_au().nextGaussian() * 10.0));
                        if (this.taskOwner.field_70163_u - (double)y > 10.0) continue;
                        if ((double)y > this.taskOwner.field_70163_u) {
                            return false;
                        }
                        this.taskOwner.field_70699_by.func_75499_g();
                        this.landingPos = new BlockPos(x, y, z);
                        this.blockFace = EnumFacing.UP;
                        return true;
                    }
                }
            }
            return false;
        }

        public void func_75249_e() {
            if (this.landingPos != null) {
                this.taskOwner.func_70661_as().func_75492_a((double)this.landingPos.func_177958_n(), (double)(this.landingPos.func_177956_o() + 1), (double)this.landingPos.func_177952_p(), 1.0);
            } else if (this.landingPlayer != null) {
                this.taskOwner.func_70661_as().func_75497_a((Entity)this.landingPlayer, 1.0);
            }
        }

        public boolean func_75253_b() {
            if (this.landingPos == null && (this.landingPlayer == null || this.landingPlayer.field_70128_L || this.landingPlayer.func_184207_aI() && !this.landingPlayer.func_184196_w((Entity)this.taskOwner)) || this.taskOwner.func_70643_av() != null) {
                return false;
            }
            return !this.taskOwner.func_70661_as().func_75500_f() || this.taskOwner.getStartLandingTicks() > 0 && this.taskOwner.field_70173_aa - this.taskOwner.getStartLandingTicks() < 240;
        }

        public void func_75246_d() {
            BlockPos targetPos;
            BlockPos blockPos = targetPos = this.landingPos != null ? this.landingPos : this.landingPlayer.func_180425_c().func_177984_a();
            if (!this.taskOwner.isLanded()) {
                if (this.taskOwner.func_180425_c().func_177954_c((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()) <= 4.0) {
                    this.taskOwner.func_70661_as().func_75499_g();
                    Vec3d actualLandingLocation = this.getActualLandingLocation();
                    BlockPos actualLandingBlockPos = new BlockPos(actualLandingLocation);
                    if (this.taskOwner.field_70170_p.func_180495_p(actualLandingBlockPos).func_185890_d((IBlockAccess)this.taskOwner.field_70170_p, actualLandingBlockPos) != null) {
                        this.landingPos = null;
                        this.landingPlayer = null;
                        return;
                    }
                    if (this.taskOwner.getStartLandingTicks() == 0) {
                        this.taskOwner.field_70180_af.func_187227_b(START_LANDING_TICKS, (Object)this.taskOwner.field_70173_aa);
                    }
                    if (this.taskOwner.func_180425_c().func_177954_c((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5) <= 1.0) {
                        double vecX = actualLandingLocation.field_72450_a - this.taskOwner.field_70165_t;
                        double vecZ = actualLandingLocation.field_72449_c - this.taskOwner.field_70161_v;
                        float rotYaw = (float)(MathHelper.func_181159_b((double)vecZ, (double)vecX) * 57.29577951308232) - 90.0f;
                        this.taskOwner.func_70012_b(actualLandingLocation.field_72450_a, actualLandingLocation.field_72448_b, actualLandingLocation.field_72449_c, rotYaw, 0.0f);
                        this.taskOwner.field_70180_af.func_187227_b(LANDED, (Object)true);
                        if (this.landingPlayer != null) {
                            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)EnumFacing.DOWN);
                            this.taskOwner.field_70180_af.func_187227_b(LANDED_PLAYER, (Object)Optional.of((Object)this.landingPlayer.func_110124_au()));
                            this.taskOwner.func_184205_a((Entity)this.landingPlayer, true);
                        } else {
                            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)this.blockFace);
                        }
                    } else {
                        double vecX = (actualLandingLocation.field_72450_a - this.taskOwner.field_70165_t) * 0.5;
                        double vecZ = (actualLandingLocation.field_72449_c - this.taskOwner.field_70161_v) * 0.5;
                        double vecY = (actualLandingLocation.field_72448_b - this.taskOwner.field_70163_u) * 0.5;
                        this.taskOwner.func_70091_d(MoverType.SELF, vecX, vecY, vecZ);
                    }
                }
            } else if (this.landingPlayer == null) {
                Vec3d actualLandingLocation = this.getActualLandingLocation();
                this.taskOwner.field_70159_w = 0.0;
                this.taskOwner.field_70181_x = 0.0;
                this.taskOwner.field_70179_y = 0.0;
                this.taskOwner.field_70133_I = true;
                this.taskOwner.func_70634_a(actualLandingLocation.field_72450_a, actualLandingLocation.field_72448_b - 0.5, actualLandingLocation.field_72449_c);
            }
        }

        public void func_75251_c() {
            this.landingPos = null;
            this.blockFace = null;
            this.landingPlayer = null;
            this.taskOwner.field_70180_af.func_187227_b(START_LANDING_TICKS, (Object)0);
            this.taskOwner.field_70180_af.func_187227_b(LANDED, (Object)false);
            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)EnumFacing.DOWN);
            this.taskOwner.field_70180_af.func_187227_b(LANDED_PLAYER, (Object)Optional.absent());
            this.taskOwner.func_184210_p();
        }

        private Vec3d getActualLandingLocation() {
            if (this.landingPlayer != null) {
                return new Vec3d(this.landingPlayer.field_70165_t, this.landingPlayer.field_70163_u + (double)this.landingPlayer.field_70131_O + (double)this.taskOwner.field_70131_O + 0.1, this.landingPlayer.field_70161_v);
            }
            switch (this.blockFace) {
                case NORTH: {
                    return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() - (double)EntityMeganeuropsis.this.field_70130_N / 2.0);
                }
                case SOUTH: {
                    return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)(this.landingPos.func_177952_p() + 1) + (double)EntityMeganeuropsis.this.field_70130_N / 2.0);
                }
                case EAST: {
                    return new Vec3d((double)(this.landingPos.func_177958_n() + 1) + (double)EntityMeganeuropsis.this.field_70130_N / 2.0, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
                }
                case WEST: {
                    return new Vec3d((double)this.landingPos.func_177958_n() - (double)EntityMeganeuropsis.this.field_70130_N / 2.0, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
                }
            }
            return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
        }
    }
}

