/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.runandor.templars;

import java.util.HashSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.mobs.runandor.templars.EntityRunicLifeform;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.LootUtil;

public abstract class EntityRuneTemplar
extends EntityCreature
implements SpecialPropertyEntity,
BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/runic_minigame.png");
    private static final DataParameter<Boolean> DISABLED = EntityDataManager.func_187226_a(EntityRuneTemplar.class, (DataSerializer)DataSerializers.field_187198_h);
    private final TreeSet<Enums.MobProperties> mobProperties = new TreeSet();
    private HashSet<EntityRunicLifeform> lifeforms = new HashSet();
    public static final float entityWidth = 1.125f;

    public EntityRuneTemplar(World world) {
        super(world);
        this.func_70105_a(1.125f, 2.0f);
        this.mobProperties.add(Enums.MobProperties.SPECIAL_COMBAT_ENTITY);
    }

    public float func_70047_e() {
        return 1.8125f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DISABLED, (Object)true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187689_f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187689_f;
    }

    private void changeState(boolean disabled) {
        this.field_70180_af.func_187227_b(DISABLED, (Object)disabled);
    }

    public boolean isDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(DISABLED);
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    protected abstract EntityRunicLifeform getLifeForm();

    protected abstract RuneItem getActivationRune();

    public boolean func_180427_aV() {
        return true;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (this.isDisabled() && heldStack.func_77973_b() == this.getActivationRune()) {
            if (ItemUtil.findInventoryItem(player, new ItemStack((Item)ItemRegister.RUNIC_ENERGY), true, 1)) {
                this.changeState(false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.isDisabled()) {
            this.func_70606_j(this.func_110143_aJ() - 0.25f);
            if (this.func_110143_aJ() < 1.0f) {
                this.doDrops();
                this.changeState(true);
                this.func_70606_j(this.func_110138_aP());
                for (EntityRunicLifeform lifeforms : this.lifeforms) {
                    lifeforms.func_70106_y();
                }
            } else if (this.field_70146_Z.nextInt(125) == 0 && this.field_70170_p.func_72872_a(EntityRunicLifeform.class, this.func_174813_aQ().func_72314_b(6.0, 3.0, 6.0)).size() <= 4) {
                EntityRunicLifeform lifeform = this.getLifeForm();
                int coordX = (int)this.field_70165_t - 3 + this.field_70146_Z.nextInt(6);
                int coordZ = (int)this.field_70161_v - 3 + this.field_70146_Z.nextInt(6);
                lifeform.func_70012_b(coordX, this.field_70163_u, coordZ, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)lifeform);
                this.lifeforms.add(lifeform);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
    }

    private void doDrops() {
        float luck = 0.0f;
        for (EntityPlayer pl : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(8.0))) {
            float plLuck = pl.func_184817_da();
            if (!(plLuck > luck)) continue;
            luck = plLuck;
        }
        for (ItemStack stack : LootUtil.generateLootWithCustomLuck(this.func_184647_J(), (WorldServer)this.field_70170_p, luck)) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

