/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld.soulscurry;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityMagicBall;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityGhostlyGoblin
extends AoARangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityGhostlyGoblin(World world) {
        super(world, 0.6f, 1.8f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
    }

    public float func_70047_e() {
        return 1.59375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 30.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_GOBLIN_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_GOBLIN_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_GOBLIN_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.WIZARD_BLAST_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityGhostlyGoblin;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityMagicBall(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    @Nonnull
    protected Enums.CreatureEvents getEventRequirement() {
        return Enums.CreatureEvents.SOUL_SCURRY;
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityPlayer) {
            PlayerUtil.consumeResource((EntityPlayer)target, Enums.Resources.SOUL, 12.0f, true);
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isMeleeDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

