/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld.bloodhunt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityBloodmist
extends AoAMeleeMob {
    public static final float entityWidth = 0.8f;

    public EntityBloodmist(World world) {
        super(world, 0.8f, 1.2f);
    }

    public float func_70047_e() {
        return 0.55f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 40.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.26;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_BLOODMIST_LIVING;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_BLOODMIST_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_BLOODMIST_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBloodmist;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityPlayer) {
            PlayerUtil.consumeResource((EntityPlayer)target, Enums.Resources.ENERGY, 40.0f, true);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    @Nonnull
    protected Enums.CreatureEvents getEventRequirement() {
        return Enums.CreatureEvents.BLOOD_HUNT;
    }
}

