/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.mysterium;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityRunicGolem
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.75f;
    private static final DataParameter<Boolean> SHIELDED = EntityDataManager.func_187226_a(EntityRunicGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private int shieldCooldown = 120;
    private int runeStoneCooldown = 0;

    public EntityRunicGolem(World world) {
        super(world, 0.75f, 1.75f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 1.59375f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDED, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 95.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.265;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_RUNIC_GOLEM_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_RUNIC_GOLEM_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.field_187605_cG;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityRunicGolem;
    }

    public void deactivateShield() {
        this.shieldCooldown = 120;
        this.setShielded(false);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.isShielded()) {
            if (EntityUtil.isMeleeDamage(source) && this.runeStoneCooldown <= 0) {
                this.runeStoneCooldown = 120;
                this.func_145779_a(ItemRegister.ACTIVE_RUNE_STONE, 1);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, 1.0f);
    }

    public boolean func_190530_aW() {
        return this.isShielded();
    }

    public boolean isShielded() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED);
    }

    private void setShielded(boolean shielded) {
        this.field_70180_af.func_187227_b(SHIELDED, (Object)shielded);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.runeStoneCooldown > 0) {
            --this.runeStoneCooldown;
        }
        if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        } else if (this.shieldCooldown == 0) {
            this.shieldCooldown = -1;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_RUNIC_GOLEM_CHANGE, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.setShielded(true);
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

