/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.mysterium;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityBanshee
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.875f;

    public EntityBanshee(World world) {
        super(world, 0.875f, 2.375f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 1.90625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.2;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 88.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.27;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_BANSHEE_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_BANSHEE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_BANSHEE_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBanshee;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (!(!(target instanceof EntityLivingBase) || target instanceof EntityPlayer && ((EntityPlayer)target).field_71071_by.func_70431_c(new ItemStack((Item)ItemRegister.SCREAM_SHIELD)))) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 150, 5, true, true));
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 150, 5, true, true));
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 150, 5, true, true));
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

