/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.misc;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIAttackAdventBow;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;

public class EntitySeaSkeleton
extends AoARangedMob {
    public static final float entityWidth = 0.55f;

    public EntitySeaSkeleton(World world) {
        super(world, 0.55f, 2.03125f);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)WeaponRegister.SPEED_BOW));
    }

    public EntitySeaSkeleton(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70012_b(posX, posY, posZ, this.field_70146_Z.nextFloat() * 360.0f, 1.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityAIAttackAdventBow<EntitySeaSkeleton>(this, 1.0, 15, 7.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AoAMinion.class, 10, true, false, minion -> minion.func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 60.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Override
    protected double getBaseArmour() {
        return 1.0;
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.field_187866_fi;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.field_187868_fj;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySeaSkeleton;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float bowDamageFactor) {
        EntityHollyArrow projectile = new EntityHollyArrow(this.field_70170_p, WeaponRegister.SPEED_BOW, (EntityLivingBase)this, this.getBaseProjectileDamage());
        double distanceFactorX = target.field_70165_t - this.field_70165_t;
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
        double distanceFactorZ = target.field_70161_v - this.field_70161_v;
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_72838_d((Entity)projectile);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

