/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.lunalus;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityLunarcher
extends AoAFlyingRangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityLunarcher(World world) {
        super(world, 0.6f, 2.0f);
        this.field_70178_ae = true;
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)WeaponRegister.LUNAR_BOW));
    }

    public float func_70047_e() {
        return 1.625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 118.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 14.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_LUNARCHER_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_LUNARCHER_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_LUNARCHER_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.field_187737_v;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityLunarcher;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    @Override
    public void func_82196_d(@Nonnull EntityLivingBase target, float bowDamageFactor) {
        EntityHollyArrow projectile = new EntityHollyArrow(this.field_70170_p, WeaponRegister.LUNAR_BOW, (EntityLivingBase)this, this.getBaseProjectileDamage());
        double distanceFactorX = target.field_70165_t - projectile.field_70165_t;
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
        double distanceFactorZ = target.field_70161_v - projectile.field_70161_v;
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_72838_d((Entity)projectile);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

