/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.crystevia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class EntityConstructStrength
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.0f;

    public EntityConstructStrength(World world) {
        super(world, 1.0f, 2.375f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 2.125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.5;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 69.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Override
    protected double getBaseArmour() {
        return 3.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityConstructOfStrength;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(0.1f);
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_188419_a() == MobEffects.field_76420_g) {
            effect.func_76452_a(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), (effect.func_76458_c() + 1) * 4, effect.func_82720_e(), effect.func_188418_e()));
        }
        super.func_70690_d(effect);
    }

    @Override
    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            if (!this.field_70170_p.field_72995_K && target instanceof EntityPlayer && ((EntityPlayer)target).func_110143_aJ() > 0.0f && this.func_70644_a(MobEffects.field_76420_g) && ItemUtil.findInventoryItem((EntityPlayer)target, new ItemStack((Item)ItemRegister.BLANK_REALMSTONE), true, 1)) {
                ItemUtil.givePlayerItemOrDrop((EntityPlayer)target, new ItemStack((Item)ItemRegister.IMMORTALLIS_REALMSTONE));
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

