/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.crystevia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityConstructResistance
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.625f;

    public EntityConstructResistance(World world) {
        super(world, 0.625f, 2.375f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 2.0f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.15;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 80.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 7.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.28;
    }

    @Override
    protected double getBaseArmour() {
        return 15.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityConstructOfResistance;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_188419_a() == MobEffects.field_76429_m) {
            effect.func_76452_a(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1, effect.func_82720_e(), effect.func_188418_e()));
        }
        super.func_70690_d(effect);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(0.1f);
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

