/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.creeponia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.mobs.creeponia.EntityCreeponiaCreeper;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityBoneCreeper
extends EntityCreeponiaCreeper
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.5f;

    public EntityBoneCreeper(World world) {
        super(world, 0.5f, 1.625f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 1.4375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 45.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.3;
    }

    @Override
    public float getExplosionStrength() {
        return 2.75f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextBoolean()) {
            return SoundsRegister.MOB_CREEPOID_LIVING;
        }
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CREEPOID_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBoneCreeper;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

