/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.abyss;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityMagicBall;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ModUtil;

public class EntityWebReaper
extends AoARangedMob {
    public static float entityWidth = 0.75f;
    public static float entityHeight = 3.5625f;
    private static final DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntityWebReaper.class, (DataSerializer)DataSerializers.field_187192_b);
    private final AttributeModifier STAGE_HEALTH_MOD = new AttributeModifier(UUID.fromString("9c59eceb-dcd0-40e0-a608-a46d3794b1c3"), "StageHealthModifier", 1.0, 2){

        public double func_111164_d() {
            return Math.max(0.0f, EntityWebReaper.this.stageMod - 1.0f);
        }
    };
    private final AttributeModifier STAGE_KNOCKBACK_MOD = new AttributeModifier(UUID.fromString("a7cd0b89-ca94-4e54-a0c4-f56e8cb70bb0"), "StageKnockbackModifier", 1.0, 2){

        public double func_111164_d() {
            return Math.max(0.0, (double)(EntityWebReaper.this.stageMod - 1.0f) * 0.83);
        }
    };
    private int stage = 1;
    private float stageMod = 1.0f;
    private boolean shouldHeal = false;

    public EntityWebReaper(World world) {
        super(world, entityWidth, entityHeight);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        EntityUtil.applyAttributeModifierSafely((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, this.STAGE_HEALTH_MOD);
        EntityUtil.applyAttributeModifierSafely((EntityLivingBase)this, SharedMonsterAttributes.field_111266_c, this.STAGE_KNOCKBACK_MOD);
        return super.func_180482_a(difficulty, livingData);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAGE, (Object)1);
    }

    public float func_70047_e() {
        return 2.375f * this.stageMod;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.6;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 107.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 13.0f * this.stageMod;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_WEB_REAPER_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_WEB_REAPER_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_WEB_REAPER_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.WEB_REAPER_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityWebReaper;
    }

    public int getStage() {
        return this.stage;
    }

    public float getStageMod() {
        return this.stageMod;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == ItemRegister.NIGHTMARE_FLAKES) {
            if (this.stage >= 10) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                heldStack.func_190918_g(1);
                ++this.stage;
                this.updateStage();
                this.shouldHeal = true;
            }
            return true;
        }
        if (heldStack.func_77973_b() == Items.field_151134_bR && this.stage > 1) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184611_a(hand, new ItemStack((Item)ItemRegister.BOOK_OF_SHADOWS));
                if (this.stage <= 10) {
                    this.stage += 5;
                    this.updateStage();
                    this.shouldHeal = true;
                }
            }
            return true;
        }
        return false;
    }

    private void updateStage() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(STAGE, (Object)this.stage);
        } else {
            this.stage = (Integer)this.field_70180_af.func_187225_a(STAGE);
        }
        this.stageMod = 1.0f + (float)(this.stage - 1) / 7.5f;
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.reapplyAttributeModifier((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, this.STAGE_HEALTH_MOD);
            EntityUtil.reapplyAttributeModifier((EntityLivingBase)this, SharedMonsterAttributes.field_111266_c, this.STAGE_KNOCKBACK_MOD);
        }
        this.func_70105_a(entityWidth * this.stageMod, entityHeight * this.stageMod);
        this.setXpValue((int)this.func_110138_aP() / 10 + (int)(((double)this.func_110138_aP() - this.getBaseMaxHealth()) * (double)0.1f));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == STAGE) {
            this.updateStage();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("WebReaperStage")) {
            this.stage = compound.func_74762_e("WebReaperStage");
            this.updateStage();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.stage > 1) {
            compound.func_74768_a("WebReaperStage", this.stage);
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityMagicBall(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier + (int)Math.ceil(this.stageMod), source);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (this.stage >= 15 && target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 1, false, true));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityPlayerMP) {
            ModUtil.completeAdvancement((EntityPlayerMP)cause.func_76346_g(), "abyss/reaper_reaper", "nightmare_web_reaper_kill");
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shouldHeal) {
            this.func_70606_j(this.func_110138_aP());
            this.shouldHeal = false;
        }
    }

    public String func_70005_c_() {
        String stagePrefix;
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String entityString = EntityList.func_75621_b((Entity)this);
        String string = this.stage >= 15 ? "nightmare" : (stagePrefix = this.stage >= 5 ? "empowered" : null);
        if (entityString == null) {
            entityString = "generic";
        }
        if (stagePrefix != null) {
            entityString = entityString + "." + stagePrefix;
        }
        return I18n.func_74838_a((String)("entity." + entityString + ".name"));
    }
}

