/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.mechbot;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityMechFall;
import net.tslat.aoa3.entity.projectiles.mob.EntityMechShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityMechbot
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity,
AoARangedAttacker {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/mechbot.png");
    public static final float entityWidth = 0.9f;
    private int jumpCooldown = 200;
    private int jumpCount = 0;
    private int jumpIntervalTimer = 0;

    public EntityMechbot(World world) {
        super(world, 0.9f, 2.4375f);
        this.mobProperties.add(Enums.MobProperties.EXPLOSION_IMMUNE);
    }

    public float func_70047_e() {
        return 2.21875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_MECHYON_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_MECHYON_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_MECHYON_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.ENTITY_GENERIC_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMechbot;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return source.func_94541_c();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() == null || this.field_70128_L) {
            return;
        }
        EntityLivingBase target = this.func_70638_az();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.jumpCooldown <= 0) {
            if (this.jumpCount < 4) {
                --this.jumpIntervalTimer;
                if (this.jumpIntervalTimer <= 0) {
                    this.field_70181_x = 0.699;
                    this.field_70159_w = (target.field_70165_t - this.field_70165_t) * 0.045;
                    this.field_70179_y = (target.field_70161_v - this.field_70161_v) * 0.045;
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_MECHBOT_JUMP, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.field_70170_p.func_72838_d((Entity)new EntityMechFall(this, this.field_70165_t, this.field_70163_u - 0.25, this.field_70161_v, Enums.MobProjectileType.MAGIC));
                        if (this.func_110143_aJ() < 1250.0f) {
                            this.field_70170_p.func_72838_d((Entity)new EntityMechFall(this, this.field_70165_t - 2.25, this.field_70163_u - 0.25, this.field_70161_v - 2.25, Enums.MobProjectileType.MAGIC));
                            this.field_70170_p.func_72838_d((Entity)new EntityMechFall(this, this.field_70165_t - 2.25, this.field_70163_u - 0.25, this.field_70161_v + 2.25, Enums.MobProjectileType.MAGIC));
                            this.field_70170_p.func_72838_d((Entity)new EntityMechFall(this, this.field_70165_t + 2.25, this.field_70163_u - 0.25, this.field_70161_v - 2.25, Enums.MobProjectileType.MAGIC));
                            this.field_70170_p.func_72838_d((Entity)new EntityMechFall(this, this.field_70165_t + 2.25, this.field_70163_u - 0.25, this.field_70161_v + 2.25, Enums.MobProjectileType.MAGIC));
                        }
                    }
                    ++this.jumpCount;
                    this.jumpIntervalTimer = 15;
                }
            } else {
                this.jumpCooldown = 200;
                this.jumpCount = 0;
                this.jumpIntervalTimer = 15;
            }
        }
        if (this.func_110143_aJ() < 1000.0f ? this.field_70146_Z.nextInt(10) == 0 : this.field_70146_Z.nextInt(40) == 0) {
            EntityMechShot projectile = new EntityMechShot(this, Enums.MobProjectileType.MAGIC);
            double distanceFactorX = target.field_70165_t - this.field_70165_t;
            double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
            double distanceFactorZ = target.field_70161_v - this.field_70161_v;
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MECHBOT_SHOOT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.mechbot.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.MECHBOT_MUSIC;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (EntityUtil.dealBlasterDamage((EntityLivingBase)this, target, (Entity)projectile, 5.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

