/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.klobber;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.PredicateUtil;

public class EntityKlobber
extends AoAMeleeMob
implements BossEntity {
    public static final float entityWidth = 0.8f;

    public EntityKlobber(World world) {
        super(world, 0.8f, 2.0f);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_IMMORTAL_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_IMMORTAL_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187689_f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityKlobber;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        for (EntityPlayer pl : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(11.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
            if (pl.func_70093_af()) continue;
            pl.func_70024_g(Math.signum(this.field_70165_t - pl.field_70165_t) * 0.019, 0.0, Math.signum(this.field_70161_v - pl.field_70161_v) * 0.019);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return null;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

