/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.kingbambambam;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.kingbambambam.EntityLittleBam;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityBloodball;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityKingBamBamBam
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/king_bambambam.png");
    public static final float entityWidth = 1.2f;
    private int minionCooldown = 60;
    private final HashSet<EntityLittleBam> summons = new HashSet();

    public EntityKingBamBamBam(World world) {
        super(world, 1.2f, 2.0f);
    }

    public float func_70047_e() {
        return 1.78125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 900.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_KING_BAMBAMBAM_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_KING_BAMBAMBAM_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_KING_BAMBAMBAM_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.ENTITY_GENERIC_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityKingBamBamBam;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityBloodball(this, Enums.MobProjectileType.MAGIC);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70128_L || this.func_175446_cd()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.minionCooldown > 0) {
                --this.minionCooldown;
            } else {
                this.minionCooldown = 60;
                EntityLittleBam littleBam = new EntityLittleBam(this);
                this.field_70170_p.func_72838_d((Entity)littleBam);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_LITTLE_BAM_SPAWN, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.summons.add(littleBam);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.kingBamBamBam.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
            for (EntityLittleBam littleBam : this.summons) {
                littleBam.func_70106_y();
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.KING_BAMBAMBAM_MUSIC;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

