/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.graw;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityGrawShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityGraw
extends AoAFlyingRangedMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/graw.png");
    public static final float entityWidth = 5.0f;
    private int pullCountdown = 400;

    public EntityGraw(World world) {
        super(world, 5.0f, 4.0f);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
    }

    public float func_70047_e() {
        return 2.0f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_GRAW_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_GRAW_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_GRAW_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityGraw;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        block7: {
            super.func_70636_d();
            if (this.field_70128_L) {
                return;
            }
            if (this.field_70170_p.field_72995_K) break block7;
            if (this.field_70163_u > 110.0) {
                this.field_70181_x -= 4.5;
                this.field_70159_w += -1.5 + (double)this.field_70146_Z.nextInt(3);
                this.field_70179_y += -1.5 + (double)this.field_70146_Z.nextInt(3);
            }
            --this.pullCountdown;
            if (this.pullCountdown < 60) {
                if (this.pullCountdown <= 0) {
                    this.pullCountdown = 400;
                }
                for (EntityPlayer pl : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(85.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
                    if (pl.func_70093_af()) continue;
                    pl.func_70024_g(Math.signum(this.field_70165_t - pl.field_70165_t) * 0.139, Math.signum(this.field_70163_u - pl.field_70163_u) * 0.04, Math.signum(this.field_70161_v - pl.field_70161_v) * 0.139);
                    pl.field_70133_I = true;
                }
            } else {
                for (EntityPlayer pl : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(85.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
                    if (pl.func_70093_af()) continue;
                    pl.func_70024_g(Math.signum(this.field_70165_t - pl.field_70165_t) * 0.008, Math.signum(this.field_70163_u - pl.field_70163_u) * 0.005, Math.signum(this.field_70161_v - pl.field_70161_v) * 0.008);
                    pl.field_70133_I = true;
                }
            }
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.5f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.5f);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityGrawShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMagicDamage(source, (Entity)this, damage);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.graw.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.GRAW_MUSIC;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

