/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.craexxeus;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.boss.craexxeus.EntityXxeus;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityCraexxeusNuke;
import net.tslat.aoa3.entity.projectiles.mob.EntityCraexxeusShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityCraexxeus
extends AoAFlyingRangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/craexxeus.png");
    public static final float entityWidth = 3.5f;
    private int chargeCooldown = 300;

    public EntityCraexxeus(World world) {
        super(world, 3.5f, 4.4375f);
    }

    public float func_70047_e() {
        return 3.9f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CRAEXXEUS_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CRAEXXEUS_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CRAEXXEUS_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.CRAEXXEUS_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCraexxeus;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityCraexxeusShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.CRAEXXEUS_MUSIC;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70181_x *= 0.15;
        if (!this.field_70170_p.field_72995_K) {
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
                if (this.chargeCooldown == 40) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_CRAEXXEUS_CHARGE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            } else {
                this.chargeCooldown = 300;
                if (this.func_70638_az() != null) {
                    EntityLivingBase target = this.func_70638_az();
                    EntityCraexxeusNuke projectile = new EntityCraexxeusNuke(this, Enums.MobProjectileType.MAGIC);
                    double distanceFactorX = target.field_70165_t - projectile.field_70165_t;
                    double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
                    double distanceFactorZ = target.field_70161_v - projectile.field_70161_v;
                    double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.CRAEXXEUS_NUKE_SHOOT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
                    this.field_70170_p.func_72838_d((Entity)projectile);
                }
            }
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (projectile instanceof EntityCraexxeusNuke) {
            EntityUtil.dealBlasterDamage((EntityLivingBase)this, target, (Entity)projectile, (float)this.getBaseProjectileDamage() * 3.0f, false);
        } else {
            super.doProjectileEntityImpact(projectile, target);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            EntityXxeus xxeus = new EntityXxeus(this);
            this.field_70170_p.func_72838_d((Entity)xxeus);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

