/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.bane;

import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.bane.EntityBaneBig;
import net.tslat.aoa3.entity.boss.bane.EntityBaneClone;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityBane
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/bane.png");
    public static final float entityWidth = 0.75f;
    private final HashSet<AoAMeleeMob> summons = new HashSet();

    public EntityBane(World world) {
        super(world, 0.75f, 2.0f);
    }

    public float func_70047_e() {
        return 1.1875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1750.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_BANE_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_BANE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_BANE_LIVING;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBane;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            for (int i = 0; i < 6; ++i) {
                EntityBaneClone clone = new EntityBaneClone(this);
                this.summons.add(clone);
                this.field_70170_p.func_72838_d((Entity)clone);
            }
        } else if (this.field_70146_Z.nextInt(300) == 0) {
            EntityBaneBig bigClone = new EntityBaneBig(this);
            this.summons.add(bigClone);
            this.field_70170_p.func_72838_d((Entity)bigClone);
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 40, 2, true, true));
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 1, true, false));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g());
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.bane.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
            for (AoAMeleeMob summon : this.summons) {
                if (summon == null) continue;
                summon.func_70106_y();
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.BANE_MUSIC;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

