/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base.ai.mob;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;

public class EntityAIFlyingFindNearestAttackableTargetHunter<T extends EntityLivingBase>
extends EntityAIBase {
    private final EntityLiving mob;
    private final Predicate<? super T> targetSelectorPredicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private T selectedTarget;
    private final Class<? extends T> targetClass;
    private final int hunterLvl;

    public EntityAIFlyingFindNearestAttackableTargetHunter(EntityLiving mob, Class<T> targetClass) {
        this(mob, targetClass, null);
    }

    public EntityAIFlyingFindNearestAttackableTargetHunter(EntityLiving mob, Class<T> targetClass, @Nullable Predicate<? super T> targetSelector) {
        this.func_75248_a(1);
        this.mob = mob;
        this.targetClass = targetClass;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)mob);
        this.hunterLvl = HunterUtil.getHunterLevel((EntityLivingBase)mob);
        this.targetSelectorPredicate = input -> {
            EntityPlayer pl;
            if (input == null || targetSelector != null && !targetSelector.apply(input)) {
                return false;
            }
            if (input instanceof EntityPlayer) {
                EntityPlayer pl2 = (EntityPlayer)input;
                if (!PredicateUtil.IS_VULNERABLE_PLAYER.apply((Object)pl2)) {
                    return false;
                }
                if (this.hunterLvl > 0 && !PlayerUtil.doesPlayerHaveLevel(pl2, Enums.Skills.HUNTER, this.hunterLvl)) {
                    return false;
                }
                return this.isSuitableTarget((EntityLivingBase)input, true);
            }
            if (this.hunterLvl > 0 && input instanceof EntityTameable && (pl = (EntityPlayer)((EntityTameable)input).func_70902_q()) != null && !PlayerUtil.doesPlayerHaveLevel(pl, Enums.Skills.HUNTER, this.hunterLvl)) {
                return false;
            }
            return this.isSuitableTarget((EntityLivingBase)input, false);
        };
    }

    public boolean func_75250_a() {
        double targetingRange = this.getTargetingRange();
        List targetList = this.mob.field_70170_p.func_175647_a(this.targetClass, this.mob.func_174813_aQ().func_72314_b(targetingRange, 4.0, targetingRange), this.targetSelectorPredicate);
        if (!targetList.isEmpty()) {
            targetList.sort(this.sorter);
            this.selectedTarget = (EntityLivingBase)targetList.get(0);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        EntityPlayer pl;
        EntityLivingBase target = this.mob.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (target instanceof EntityPlayer && ((pl = (EntityPlayer)target).func_184812_l_() || pl.func_175149_v() || pl.field_71075_bZ.field_75102_a)) {
            return false;
        }
        if (target.func_96124_cp() != null && target.func_96124_cp() == this.mob.func_96124_cp()) {
            return false;
        }
        double targetingRange = this.getTargetingRange();
        return !(this.mob.func_70068_e((Entity)target) > targetingRange * targetingRange);
    }

    public void func_75249_e() {
        this.mob.func_70624_b(this.selectedTarget);
    }

    public void func_75251_c() {
        this.mob.func_70624_b(null);
    }

    private boolean isSuitableTarget(EntityLivingBase target, boolean isPlayer) {
        if (target.func_96124_cp() != null && target.func_96124_cp() == this.mob.func_96124_cp()) {
            return false;
        }
        double targetingRange = this.getTargetingRange();
        if (target.func_70093_af()) {
            targetingRange *= 0.8;
        }
        if (target.func_82150_aj()) {
            if (!isPlayer) {
                return false;
            }
            targetingRange *= 0.7 * Math.max(0.1, (double)((EntityPlayer)target).func_82243_bO());
        }
        return !((double)target.func_70032_d((Entity)this.mob) > targetingRange) && EntityAITarget.func_179445_a((EntityLiving)this.mob, (EntityLivingBase)target, (boolean)false, (boolean)true);
    }

    private double getTargetingRange() {
        IAttributeInstance followRange = this.mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return followRange == null ? 16.0 : followRange.func_111126_e();
    }
}

