/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;

public abstract class AoARangedMob
extends EntityMob
implements IRangedAttackMob,
AoARangedAttacker {
    private static final DataParameter<Boolean> SHOOTING = EntityDataManager.func_187226_a(AoARangedMob.class, (DataSerializer)DataSerializers.field_187198_h);
    protected final TreeSet<Enums.MobProperties> mobProperties = this instanceof SpecialPropertyEntity ? new TreeSet() : null;
    private boolean isSlipperyMob = false;

    public AoARangedMob(World world, float entityWidth, float entityHeight) {
        super(world);
        this.func_70105_a(entityWidth, entityHeight);
        this.setXpValue((int)(5.0 + (this.getBaseMaxHealth() + this.getBaseArmour() * 1.75 + this.getBaseProjectileDamage() * 2.0) / 10.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOTING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 40, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AoAMinion.class, 10, true, false, EntityTameable::func_70909_n));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth() * (double)(ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 2.0f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmour() * (double)(ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 1.25f : 1.0f));
    }

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    public abstract double getBaseProjectileDamage();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseArmour() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent getStepSound() {
        return null;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected void setXpValue(int amount) {
        this.field_70728_aV = amount;
    }

    protected void setSlipperyMovement() {
        this.isSlipperyMob = true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.checkWorldRequirements() && this.checkSpawnChance() && this.func_70814_o() && this.canSpawnOnBlock(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean isOverworldMob() {
        return false;
    }

    protected boolean func_70814_o() {
        int light;
        if (this.isDaylightMob() || !this.isOverworldMob()) {
            if (!this.field_70170_p.func_72935_r() && this.isDaylightMob()) {
                return false;
            }
            return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= this.field_70146_Z.nextInt(8);
        }
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockPos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        if (this.field_70170_p.func_72911_I()) {
            int skylightSubtracted = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            light = this.field_70170_p.func_175671_l(blockPos);
            this.field_70170_p.func_175692_b(skylightSubtracted);
        } else {
            light = this.field_70170_p.func_175671_l(blockPos);
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    protected boolean isDaylightMob() {
        return false;
    }

    private boolean checkSpawnChance() {
        if (this.isOverworldMob()) {
            if (this.isDaylightMob()) {
                return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor());
            }
            return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor() * 4.0);
        }
        return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor());
    }

    protected double getSpawnChanceFactor() {
        return ConfigurationUtil.EntityConfig.mobSpawnFrequencyModifier;
    }

    protected boolean canSpawnOnBlock(IBlockState block) {
        return block.func_189884_a((Entity)this);
    }

    private boolean checkWorldRequirements() {
        if (this.isOverworldMob() && this.field_70170_p.field_73011_w.getDimension() != 0) {
            EntityRegistry.removeSpawn(this.getClass(), (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{this.field_70170_p.func_180494_b(this.func_180425_c())});
            return false;
        }
        Enums.CreatureEvents eventReq = this.getEventRequirement();
        return eventReq == null || OverworldEvents.isEventActive(eventReq);
    }

    @Nullable
    protected Enums.CreatureEvents getEventRequirement() {
        return null;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70058_J() {
        return !this.func_70648_aU() ? super.func_70058_J() : this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.getStepSound() != null) {
            this.func_184185_a(this.getStepSound(), 0.55f, 1.0f);
        } else {
            super.func_180429_a(pos, block);
        }
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SHOOTING, (Object)swingingArms);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOOTING);
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float bowDamageFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.field_70165_t - this.field_70165_t;
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
        double distanceFactorZ = target.field_70161_v - this.field_70161_v;
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_72838_d((Entity)projectile);
    }

    protected abstract BaseMobProjectile getNewProjectileInstance();

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        boolean success;
        float mod = ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 1.5f : 1.0f;
        switch (projectile.getProjectileType()) {
            case MAGIC: {
                success = EntityUtil.dealMagicDamage((Entity)projectile, (EntityLivingBase)this, target, (float)this.getBaseProjectileDamage() * mod, false);
                break;
            }
            case GUN: {
                success = EntityUtil.dealGunDamage(target, (EntityLivingBase)this, projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            case PHYSICAL: {
                success = EntityUtil.dealRangedDamage(target, (EntityLivingBase)this, (Entity)projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            default: {
                success = target.func_70097_a(DamageSource.func_188403_a((Entity)projectile, (EntityLivingBase)this), (float)this.getBaseProjectileDamage() * mod);
            }
        }
        if (success) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        if (this.func_190530_aW()) {
            return true;
        }
        return this.isSpecialImmuneTo(source, 1);
    }

    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return false;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.func_184647_J() != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(this.func_184647_J());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da() + (float)lootingModifier);
            }
            for (ItemStack stack : lootTable.func_186462_a(this.field_70146_Z, lootBuilder.func_186471_a())) {
                this.func_70099_a(stack, 0.0f);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        double movedZ;
        if (this.func_70613_aW() || this.func_184186_bw()) {
            if (!this.func_70090_H()) {
                if (!this.func_180799_ab()) {
                    if (this.func_184613_cA()) {
                        double newMotion;
                        float impactVelocity;
                        if (this.field_70181_x > -0.5) {
                            this.field_70143_R = 1.0f;
                        }
                        Vec3d lookVec = this.func_70040_Z();
                        float lookPitch = this.field_70125_A * ((float)Math.PI / 180);
                        double lookVecHypot = Math.sqrt(lookVec.field_72450_a * lookVec.field_72450_a + lookVec.field_72449_c * lookVec.field_72449_c);
                        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                        float pitchAngle = MathHelper.func_76134_b((float)lookPitch);
                        pitchAngle = (float)((double)pitchAngle * (double)pitchAngle * Math.min(1.0, lookVec.func_72433_c() / 0.4));
                        this.field_70181_x += -0.08 + (double)pitchAngle * 0.06;
                        if (this.field_70181_x < 0.0 && lookVecHypot > 0.0) {
                            double motionYMod = this.field_70181_x * -0.1 * (double)pitchAngle;
                            this.field_70181_x += motionYMod;
                            this.field_70159_w += lookVec.field_72450_a * motionYMod / lookVecHypot;
                            this.field_70179_y += lookVec.field_72449_c * motionYMod / lookVecHypot;
                        }
                        if (lookPitch < 0.0f) {
                            double inverseMotionMod = motion * (double)(-MathHelper.func_76126_a((float)lookPitch)) * 0.04;
                            this.field_70181_x += inverseMotionMod * 3.2;
                            this.field_70159_w -= lookVec.field_72450_a * inverseMotionMod / lookVecHypot;
                            this.field_70179_y -= lookVec.field_72449_c * inverseMotionMod / lookVecHypot;
                        }
                        if (lookVecHypot > 0.0) {
                            this.field_70159_w += (lookVec.field_72450_a / lookVecHypot * motion - this.field_70159_w) * 0.1;
                            this.field_70179_y += (lookVec.field_72449_c / lookVecHypot * motion - this.field_70179_y) * 0.1;
                        }
                        this.field_70159_w *= (double)0.99f;
                        this.field_70181_x *= (double)0.98f;
                        this.field_70179_y *= (double)0.99f;
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (this.field_70123_F && !this.field_70170_p.field_72995_K && (impactVelocity = (float)((motion - (newMotion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 10.0 - 3.0)) > 0.0f) {
                            this.func_184185_a(this.func_184588_d((int)impactVelocity), 1.0f, 1.0f);
                            this.func_70097_a(DamageSource.field_188406_j, impactVelocity);
                        }
                        if (!this.field_70170_p.field_72995_K && this.field_70122_E) {
                            this.func_70052_a(7, false);
                        }
                    } else {
                        float friction = 0.91f;
                        BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
                        if (this.field_70122_E) {
                            IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)checkPos);
                            friction = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)checkPos, (Entity)this) * 0.91f;
                            if (this.isSlipperyMob) {
                                friction = (float)((double)friction * 0.85);
                            }
                        }
                        friction = 0.16277136f / (friction * friction * friction);
                        float frictionMod = this.field_70122_E ? this.func_70689_ay() * friction : this.field_70747_aH;
                        this.func_191958_b(strafe, vertical, forward, frictionMod);
                        friction = 0.91f;
                        if (this.field_70122_E) {
                            IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v));
                            friction = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)checkPos, (Entity)this) * 0.91f;
                            if (this.isSlipperyMob) {
                                friction = (float)((double)friction * 0.85);
                            }
                        }
                        if (this.func_70617_f_()) {
                            this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.15f, (double)0.15f);
                            this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.15f, (double)0.15f);
                            this.field_70143_R = 0.0f;
                            if (this.field_70181_x < -0.15) {
                                this.field_70181_x = -0.15;
                            }
                            if (this.func_70093_af() && this.field_70181_x < 0.0) {
                                this.field_70181_x = 0.0;
                            }
                        }
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (this.field_70123_F && this.func_70617_f_()) {
                            this.field_70181_x = 0.2;
                        }
                        if (this.func_70644_a(MobEffects.field_188424_y)) {
                            this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
                        } else {
                            checkPos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                            if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)checkPos) && this.field_70170_p.func_175726_f((BlockPos)checkPos).func_177410_o()) {
                                if (!this.func_189652_ae()) {
                                    this.field_70181_x -= 0.08;
                                }
                            } else {
                                this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                            }
                        }
                        this.field_70181_x *= (double)0.98f;
                        this.field_70159_w *= (double)friction;
                        this.field_70179_y *= (double)friction;
                        checkPos.func_185344_t();
                    }
                } else {
                    this.func_191958_b(strafe, vertical, forward, 0.02f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.02;
                    }
                    if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f, this.field_70179_y)) {
                        this.field_70181_x = 0.3f;
                    }
                }
            } else {
                float waterDrag = this.func_189749_co();
                float friction = 0.02f;
                float depthStriderMod = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (depthStriderMod > 3.0f) {
                    depthStriderMod = 3.0f;
                }
                if (!this.field_70122_E) {
                    depthStriderMod *= 0.5f;
                }
                if (depthStriderMod > 0.0f) {
                    waterDrag += (0.54600006f - waterDrag) * depthStriderMod / 3.0f;
                    friction += (this.func_70689_ay() - friction) * depthStriderMod / 3.0f;
                }
                this.func_191958_b(strafe, vertical, forward, friction);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)waterDrag;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)waterDrag;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.02;
                }
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double movedX = this.field_70165_t - this.field_70169_q;
        double movedY = this instanceof EntityFlying ? this.field_70163_u - this.field_70167_r : 0.0;
        float moveDistance = MathHelper.func_76133_a((double)(movedX * movedX + movedY * movedY + (movedZ = this.field_70161_v - this.field_70166_s) * movedZ)) * 4.0f;
        if (moveDistance > 1.0f) {
            moveDistance = 1.0f;
        }
        this.field_70721_aZ += (moveDistance - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }
}

