/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.generation.stone.StoneBlock;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;

public abstract class AoAAnimal
extends EntityAnimal {
    protected final TreeSet<Enums.MobProperties> mobProperties = this instanceof SpecialPropertyEntity ? new TreeSet() : null;

    public AoAAnimal(World world, float entityWidth, float entityHeight) {
        super(world);
        this.field_70728_aV = (int)this.getBaseMaxHealth() / 25;
        this.func_70105_a(entityWidth, entityHeight);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (this.isBreedable()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
            if (this.getTemptItem() != null) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, this.getTemptItem(), false));
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmor());
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    protected double getBaseArmor() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187566_ao;
    }

    public boolean func_70601_bi() {
        BlockPos checkPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        IBlockState spawnBlock = this.field_70170_p.func_180495_p(checkPos.func_177977_b());
        return this.checkSpawnChance() && (spawnBlock.func_177230_c() instanceof BlockGrass || spawnBlock.func_177230_c() instanceof BlockStone || spawnBlock.func_177230_c() instanceof StoneBlock) && spawnBlock.func_189884_a((Entity)this) && this.checkSpawningLightConditions() && this.func_180484_a(checkPos) >= 0.0f;
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance() {
        return this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean checkSpawningLightConditions() {
        return this.field_70170_p.func_175699_k(this.func_180425_c()) > 8;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == this.getTemptItem();
    }

    protected boolean isBreedable() {
        return false;
    }

    @Nullable
    protected Item getTemptItem() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.getStepSound() != null) {
            this.func_184185_a(this.getStepSound(), 0.55f, 1.0f);
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable mate) {
        return null;
    }
}

