/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.utils.WorldUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class AoAAmbientNPC
extends EntityCreature
implements INpc {
    public AoAAmbientNPC(World world, float entityWidth, float entityHeight) {
        super(world);
        this.func_70105_a(entityWidth, entityHeight);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, AoAMeleeMob.class, 8.0f, (double)0.8f, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.AMBIENT;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    @Nullable
    protected abstract String getInteractMessage(ItemStack var1);

    protected boolean isFixedTradesList() {
        return false;
    }

    public boolean func_70601_bi() {
        return this.checkSpawnChance() && this.isValidLightLevel() && this.canSpawnOnBlock(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnOnBlock(IBlockState block) {
        return block.func_189884_a((Entity)this) && WorldUtil.isNaturalDimensionBlock(this.field_70170_p, this.func_180425_c(), block);
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance() {
        return this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return true;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i > this.field_70146_Z.nextInt(8);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.func_184647_J() != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(this.func_184647_J());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da() + (float)lootingModifier);
            }
            for (ItemStack stack : lootTable.func_186462_a(this.field_70146_Z, lootBuilder.func_186471_a())) {
                this.func_70099_a(stack, 0.0f);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        String msg;
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == Items.field_151057_cb) {
            heldStack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && (msg = this.getInteractMessage(heldStack)) != null) {
            PlayerUtil.notifyPlayer((EntityPlayerMP)player, msg, TextFormatting.GRAY);
        }
        return super.func_184645_a(player, hand);
    }
}

