/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.runandor;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenRunandor
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.RUNANDOR;
    private int x;
    private int y;
    private int z;
    private int count;

    protected ChunkGenRunandor(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
        this.count = this.rand.nextInt(26);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        if (this.count > 25) {
            this.count = 0;
        }
        this.setBlocksInChunk();
        Chunk chunk = new Chunk(this.world, this.primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        chunk.func_76603_b();
        ++this.count;
        return chunk;
    }

    private void setBlocksInChunk() {
        this.setAllBlocksBetweenYCoords(0, 11 + this.count, BlockRegister.RUNIC_STONE.func_176223_P());
        this.setAllBlocksBetweenYCoords(11 + this.count, 11 + this.count, 11 + this.count <= 14 ? BlockRegister.RUNIC_STONE.func_176223_P() : BlockRegister.RUNIC_GRASS.func_176223_P());
        if (this.count < 4) {
            this.x = 0;
            while (this.x <= 15) {
                this.y = 12 + this.count;
                while (this.y <= 15) {
                    this.z = 0;
                    while (this.z <= 15) {
                        this.primer.func_177855_a(this.x, this.y, this.z, Blocks.field_150355_j.func_176223_P());
                        ++this.z;
                    }
                    ++this.y;
                }
                ++this.x;
            }
        }
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 5; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (y > 2) continue;
                    this.primer.func_177855_a(x, y, z, BlockRegister.DIMENSIONAL_FABRIC.func_176223_P());
                }
            }
        }
    }

    private void setAllBlocksBetweenYCoords(int lowerY, int upperY, IBlockState block) {
        this.setAllBlocksInRegion(0, lowerY, 0, 15, upperY, 15, block);
    }

    private void setAllBlocksInRegion(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, IBlockState block) {
        this.x = lowerX;
        while (this.x <= upperX) {
            this.y = lowerY;
            while (this.y <= upperY) {
                this.z = lowerZ;
                while (this.z <= upperZ) {
                    this.primer.func_177855_a(this.x, this.y, this.z, block);
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.runandor.clunkheadArenaSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.runandor.clunkheadArenaSpawnChance) == 0) {
            int z;
            int y;
            int x = baseX + this.rand.nextInt(6);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 12, (y = this.world.func_189649_b(x + 12, (z = baseZ + this.rand.nextInt(10)) + 10)) - 1, z + 10)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("ClunkheadArena", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.runandor.runicTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.runandor.runicTowerSpawnChance) == 0) {
            int z;
            int y;
            int x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = this.world.func_189649_b(x + 5, (z = baseZ + this.rand.nextInt(16)) + 5)) - 1, z + 5)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("RunicTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.runandor.spectralCageSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.runandor.spectralCageSpawnChance) == 0) {
            int z;
            int y;
            int x = baseX + this.rand.nextInt(13);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = this.world.func_189649_b(x + 8, (z = baseZ + this.rand.nextInt(16)) + 7)) - 1, z + 7)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("SpectralCage", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.runandor.runeRandomisationStationSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.runandor.runeRandomisationStationSpawnChance) == 0) {
            int z;
            int y;
            int x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 7, (y = this.world.func_189649_b(x + 7, (z = baseZ + this.rand.nextInt(16)) + 7)) - 1, z + 7)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("RuneRandomisationStation", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.runandor.runeTemplarBunkerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.runandor.runeTemplarBunkerSpawnChance) == 0) {
            int x = baseX + this.rand.nextInt(16);
            int z = baseZ + this.rand.nextInt(16);
            int y = 3;
            if (this.world.func_189649_b(x + 7, z + 7) > 11) {
                StructuresHandler.generateStructure("RuneTemplarBunker", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

