/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.mysterium.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeMysterium
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Mysterium");

    public BiomeMysterium() {
        super(properties);
        this.setRegistryName("aoa3", "mysterium");
        this.field_76752_A = BlockRegister.getUnmappedBlock("mysterium_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("mysterium_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeMysteriumDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.RED.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.4f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(new Color(88, 51, 142).getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.22f);
    }

    public class BiomeMysteriumDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < ConfigurationUtil.OreConfig.mystite.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.MYSTITE_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.mystite.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.mystite.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.MYSTERIUM_STONE)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(20) + 2, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (world.func_180495_p(basePos).func_177230_c() != Blocks.field_150355_j) {
                for (int x = 0; x < 16; ++x) {
                    block14: for (int z = 0; z < 16; ++z) {
                        if (!rand.nextBoolean() || world.func_180495_p((BlockPos)pos.func_181079_c(posX = basePos.func_177958_n() + x, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + z)) - 1, posZ)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                        switch (rand.nextInt(5)) {
                            case 0: {
                                world.func_175656_a(pos.func_177984_a(), BlockRegister.MYSTIC_BUSH.func_176223_P());
                                continue block14;
                            }
                            case 1: {
                                world.func_175656_a(pos.func_177984_a(), BlockRegister.MYSTIC_FERNS.func_176223_P());
                                continue block14;
                            }
                            case 2: {
                                world.func_175656_a(pos.func_177984_a(), BlockRegister.RAINBOW_GRASS.func_176223_P());
                                continue block14;
                            }
                            case 3: {
                                world.func_175656_a(pos.func_177984_a(), BlockRegister.RAINBOW_GRASS2.func_176223_P());
                                continue block14;
                            }
                            case 4: {
                                world.func_175656_a(pos.func_177984_a(), BlockRegister.RAINBOW_GRASS3.func_176223_P());
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < 3; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = world.func_189649_b(posX, posZ);
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.nextInt(4)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("TinyBlueMushroom");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("TinyGreenMushroom");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("TinyOrangeMushroom");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("TinyYellowMushroom");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block8: for (int i = 0; i < 3; ++i) {
                switch (rand.nextInt(6)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(4);
                        posZ = basePos.func_177952_p() + rand.nextInt(4);
                        posY = world.func_189649_b(posX + 6, posZ + 6);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("BlueMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(4);
                        posZ = basePos.func_177952_p() + rand.nextInt(4);
                        posY = world.func_189649_b(posX + 6, posZ + 6);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("GreenMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(8);
                        posZ = basePos.func_177952_p() + rand.nextInt(8);
                        posY = world.func_189649_b(posX + 4, posZ + 4);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("OrangeMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(8);
                        posZ = basePos.func_177952_p() + rand.nextInt(8);
                        posY = world.func_189649_b(posX + 4, posZ + 4);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("PurpleMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(9);
                        posZ = basePos.func_177952_p() + rand.nextInt(9);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("YellowMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(10);
                        posZ = basePos.func_177952_p() + rand.nextInt(10);
                        posY = world.func_189649_b(posX + 2, posZ + 2);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() == Blocks.field_150350_a) continue block8;
                        StructuresHandler.generateStructure("MiniBlueMushroomTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

