/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.iromine.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.worldgen.trees.WorldGenIrodustTree;
import net.tslat.aoa3.worldgen.trees.WorldGenIrogoldTree;

public class BiomeIromine
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Iromine");

    public BiomeIromine() {
        super(properties);
        this.setRegistryName("aoa3", "iromine");
        this.field_76752_A = BlockRegister.getUnmappedBlock("iromine_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("iromine_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeIromineDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 0;
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.4f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(new Color(255, 249, 173).getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.5f);
    }

    public class BiomeIromineDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < ConfigurationUtil.OreConfig.lyon.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.LYON_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.lyon.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.lyon.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.IROMINE_STONE)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(20) + 45, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < 40; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != BiomeIromine.this.field_76752_A) continue;
                switch (rand.nextInt(3)) {
                    case 0: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.IRO_GRASS.func_176223_P());
                        continue block5;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.LURCHIANS.func_176223_P());
                        continue block5;
                    }
                    case 2: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.IROTOPS.func_176223_P());
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 3; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, (posY = world.func_189649_b(posX + 4, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 4)) - 1, posZ + 4)) != biome.field_76752_A) continue;
                if (rand.nextBoolean()) {
                    new WorldGenIrogoldTree(null).func_180709_b(world, rand, pos.func_177984_a());
                    continue;
                }
                new WorldGenIrodustTree(null).func_180709_b(world, rand, pos.func_177984_a());
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (rand.nextInt(50) == 0 && world.func_180495_p((BlockPos)pos.func_181079_c((posX = basePos.func_177958_n() + rand.nextInt(16)) + 3, posY = world.func_189649_b(posX + 3, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 3) + 15 + rand.nextInt(5), posZ + 3)).func_177230_c() == Blocks.field_150350_a) {
                if (rand.nextBoolean()) {
                    StructuresHandler.generateStructure("IroDoubler", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                } else {
                    StructuresHandler.generateStructure("IroFloater", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }
}

