/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.haven.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.worldgen.trees.WorldGenHavenTree;

public class BiomeHaven
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Haven");

    public BiomeHaven() {
        super(properties);
        this.setRegistryName("aoa3", "haven");
        this.field_76752_A = BlockRegister.getUnmappedBlock("haven_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("haven_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeHavenDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.VOID});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.GREEN.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.5f);
        properties.func_185395_b(0.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.1f);
        properties.func_185400_d(0.2f);
    }

    public class BiomeHavenDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < ConfigurationUtil.OreConfig.crystallite.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.CRYSTALLITE_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.crystallite.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.crystallite.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.HAVEN_STONE)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(40) + 30, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            block11: for (i = 0; i < 50; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                switch (rand.nextInt(7)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.HAVEN_GRASS_PLANT.func_176223_P());
                        continue block11;
                    }
                    case 4: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.DAYLOOMS_BLUE.func_176223_P());
                        continue block11;
                    }
                    case 5: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.DAYLOOMS_YELLOW.func_176223_P());
                        continue block11;
                    }
                    case 6: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.DAYLOOMS_PINK.func_176223_P());
                    }
                }
            }
            for (i = 0; i < 5; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.nextInt(3)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("BlueHavendales");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("PinkHavendales");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("YellowHavendales");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 3; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, (posY = world.func_189649_b(posX + 7, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 7)) - 1, posZ + 7)) != biome.field_76752_A) continue;
                new WorldGenHavenTree(null, null, rand).func_180709_b(world, rand, (BlockPos)pos);
            }
        }
    }
}

