/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.creeponia.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.worldgen.trees.WorldGenCreepTree;

public class BiomeCreeponia
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Creeponia");

    public BiomeCreeponia() {
        super(properties);
        this.setRegistryName("aoa3", "creeponia");
        this.field_76752_A = BlockRegister.getUnmappedBlock("creeponia_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("creeponia_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeCreeponiaDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.YELLOW.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.4f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(Color.GREEN.getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.25f);
    }

    public class BiomeCreeponiaDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.ornamyte.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.ORNAMYTE_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.ornamyte.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.ornamyte.maxOresPerVein) + 1), block -> block.func_177230_c() == BlockRegister.CREEP_STONE || block.func_177230_c() == BlockRegister.PRIMED_STONE || block.func_177230_c() == BlockRegister.UNSTABLE_STONE).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(12) + 3, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.gemenyte.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.GEMENYTE_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.gemenyte.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.gemenyte.maxOresPerVein) + 1), block -> block.func_177230_c() == BlockRegister.CREEP_STONE || block.func_177230_c() == BlockRegister.PRIMED_STONE || block.func_177230_c() == BlockRegister.UNSTABLE_STONE).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(15) + 22, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.jewelyte.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.JEWELYTE_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.jewelyte.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.jewelyte.maxOresPerVein) + 1), block -> block.func_177230_c() == BlockRegister.CREEP_STONE || block.func_177230_c() == BlockRegister.PRIMED_STONE || block.func_177230_c() == BlockRegister.UNSTABLE_STONE).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(15) + 22, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 60; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.CREEP_GRASS.func_176223_P());
                    continue;
                }
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.CREEP_FLOWERS.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 7; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, (posY = world.func_189649_b(posX + 3, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 3)) - 1, posZ + 3)) != biome.field_76752_A) continue;
                new WorldGenCreepTree(null).func_180709_b(world, rand, pos.func_177984_a());
            }
        }
    }
}

