/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.candyland.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeCandyland
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Candyland");

    public BiomeCandyland() {
        super(properties);
        this.setRegistryName("aoa3", "candyland");
        this.field_76752_A = BlockRegister.getUnmappedBlock("candyland_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("candyland_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeCandylandDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.YELLOW.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.4f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(0x993333);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.1f);
    }

    public class BiomeCandylandDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            block7: for (i = 0; i < 10; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
                switch (rand.nextInt(5)) {
                    case 0: {
                        StructuresHandler.generateStructure("CandyTube", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block7;
                    }
                    case 1: {
                        StructuresHandler.generateStructure("CandyStack", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block7;
                    }
                    case 2: {
                        StructuresHandler.generateStructure("GreenPeppermintStack", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block7;
                    }
                    case 3: {
                        StructuresHandler.generateStructure("RedPeppermintStack", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block7;
                    }
                    case 4: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.CANDYCANE.func_176223_P());
                    }
                }
            }
            for (i = 0; i < 100; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.CANDY_GRASS.func_176223_P());
                    continue;
                }
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.BLUE_CANDY_GRASS.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            switch (rand.nextInt(12)) {
                case 0: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 1, posZ + 6);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 6)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CandyCane1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 4, posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CandyCane2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 1, posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CandyCane3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 3: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 1, posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CandyCane4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 4: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CottonCandyTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 5: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("CottonCandyTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 6: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("AquaCottonCandyTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 7: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("AquaCottonCandyTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 8: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("Lollypop1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 9: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 2);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("Lollypop2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 10: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 4, posZ);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("SwirlPop1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 11: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX, posZ + 4);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 4)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("SwirlPop2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (rand.nextInt(3) == 0) {
                switch (rand.nextInt(6)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("ChocolateBar1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("ChocolateBar2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("WhiteChocolateBar1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("WhiteChocolateBar2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("DarkChocolateBar1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("DarkChocolateBar2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

