/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ITeleporter;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.capabilities.providers.AdventPlayerProvider;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class AoATeleporter
implements ITeleporter {
    protected final WorldServer fromWorld;

    public AoATeleporter(WorldServer fromWorld) {
        this.fromWorld = fromWorld;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        BlockPos pos;
        double movementFactor;
        PlayerDataManager plData = null;
        if (entity.hasCapability(AdventPlayerProvider.ADVENT_PLAYER, null)) {
            entity.func_189654_d(false);
            plData = PlayerUtil.getAdventPlayer((EntityPlayer)entity);
            PortalCoordinatesContainer loc = plData.getPortalReturnLocation(world.field_73011_w.getDimension());
            if (loc != null) {
                BlockPos locPos = loc.asBlockPos();
                Block locationBlock = world.func_180495_p(locPos).func_177230_c();
                if (locationBlock == this.getPortalBlock()) {
                    this.placeInPortal(world, entity, locPos);
                    return;
                }
                if (!(locationBlock instanceof PortalBlock)) {
                    plData.removePortalReturnLocation(world.field_73011_w.getDimension());
                }
            }
        }
        if ((movementFactor = world.field_73011_w.getMovementFactor() / this.fromWorld.field_73011_w.getMovementFactor()) != 1.0) {
            entity.func_70634_a(entity.field_70165_t * movementFactor, entity.field_70163_u, entity.field_70161_v * movementFactor);
        }
        if (this.fromWorld.func_180495_p(entity.func_180425_c()).func_177230_c() == this.getPortalBlock()) {
            ChunkPos chunkPos = this.fromWorld.func_175726_f(entity.func_180425_c()).func_76632_l();
            this.getCachedPortalMap().put(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b), entity.func_180425_c());
        }
        if ((pos = this.findExistingPortal(world, entity)) == null) {
            pos = this.findSuitablePortalLocation(world, entity);
            pos = this.makePortal(world, entity, pos);
        }
        this.placeInPortal(world, entity, pos);
        ChunkPos chunkPos = world.func_175726_f(pos).func_76632_l();
        this.getCachedPortalMap().put(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b), pos);
        if (plData != null) {
            PortalCoordinatesContainer returnPortalLoc;
            PortalCoordinatesContainer portalLoc = plData.getPortalReturnLocation(world.field_73011_w.getDimension());
            if (portalLoc != null && (returnPortalLoc = plData.getPortalReturnLocation(entity.field_70170_p.field_73011_w.getDimension())) != null && returnPortalLoc.fromDim == world.field_73011_w.getDimension()) {
                return;
            }
            if (portalLoc == null || entity.field_70170_p.field_73011_w.getDimension() == portalLoc.fromDim || entity.func_174818_b(portalLoc.asBlockPos()) > (double)ConfigurationUtil.MainConfig.portalSearchRadius) {
                plData.setPortalReturnLocation(world.field_73011_w.getDimension(), new PortalCoordinatesContainer(entity.field_70170_p.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            }
        }
    }

    public BlockPos findExistingPortal(World world, Entity entity) {
        int z;
        int x;
        int posX = (int)Math.floor(entity.field_70165_t);
        int posY = (int)Math.floor(entity.field_70163_u);
        int posZ = (int)Math.floor(entity.field_70161_v);
        ChunkPos chunkPos = world.func_175726_f(new BlockPos(posX, posY, posZ)).func_76632_l();
        Long chunkPosLong = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
        HashMap<Long, BlockPos> cachedPortalMap = this.getCachedPortalMap();
        if (cachedPortalMap.containsKey(chunkPosLong)) {
            BlockPos pos = cachedPortalMap.get(chunkPosLong);
            if (world.func_180495_p(pos).func_177230_c() == this.getPortalBlock()) {
                return cachedPortalMap.get(chunkPosLong);
            }
            cachedPortalMap.remove(chunkPosLong);
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int searchRadius = ConfigurationUtil.MainConfig.portalSearchRadius;
        int worldHeight = world.func_72940_L();
        if (posY >= worldHeight) {
            posY = 65;
        }
        if (world.func_180495_p((BlockPos)checkPos.func_181079_c(posX, posY, posZ)).func_177230_c() == this.getPortalBlock()) {
            while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.getPortalBlock()) {
            }
            Chunk chunk = world.func_175726_f((BlockPos)checkPos.func_189536_c(EnumFacing.UP));
            cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (BlockPos)checkPos);
            return checkPos;
        }
        for (int i = 1; i <= searchRadius; ++i) {
            for (int y = -i; y <= i; y += i * 2) {
                int y2 = posY + y;
                if (y2 < 0 || y2 >= worldHeight) continue;
                int xNeg = -1;
                for (int x2 = 0; x2 <= i; ++x2) {
                    int x22 = posX + x2 * xNeg;
                    if (xNeg == 1 && x2 != 0) {
                        --x2;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z2 = 0; z2 <= i; ++z2) {
                        int z22 = posZ + z2 * zNeg;
                        if (zNeg == 1 && z2 != 0) {
                            --z2;
                        }
                        zNeg *= -1;
                        checkPos.func_181079_c(x22, y2, z22);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        Chunk chunk = world.func_175726_f((BlockPos)checkPos.func_189536_c(EnumFacing.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
            int yNeg = -1;
            for (int y = 0; y <= i - 1; ++y) {
                int y2 = posY + y * yNeg;
                if (y2 < 0 || y2 >= worldHeight) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z3 = 0; z3 <= i; ++z3) {
                    int z2 = posZ + z3 * zNeg;
                    if (zNeg == 1 && z3 != 0) {
                        --z3;
                    }
                    zNeg *= -1;
                    for (int x3 = -i; x3 <= i; x3 += i * 2) {
                        int x2 = posX + x3;
                        checkPos.func_181079_c(x2, y2, z2);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        Chunk chunk = world.func_175726_f((BlockPos)checkPos.func_189536_c(EnumFacing.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
                int xNeg = 1;
                for (int x4 = 1; x4 <= i - 1; ++x4) {
                    int x2 = posX + x4 * xNeg;
                    if (xNeg == 1 && x4 != 0) {
                        --x4;
                    }
                    xNeg *= -1;
                    for (int z4 = -i; z4 <= i; z4 += i * 2) {
                        int z2 = posZ + z4;
                        checkPos.func_181079_c(x2, y2, z2);
                        if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                        while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.getPortalBlock()) {
                        }
                        Chunk chunk = world.func_175726_f((BlockPos)checkPos.func_189536_c(EnumFacing.UP));
                        cachedPortalMap.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, worldHeight, z);
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() != this.getPortalBlock() && checkPos.func_177956_o() >= 0) {
                }
                if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == this.getPortalBlock()) {
                }
                return checkPos.func_177981_b(2).func_185334_h();
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, posY, z);
                while (world.func_180495_p((BlockPos)checkPos.func_189536_c(EnumFacing.UP)).func_177230_c() != this.getPortalBlock() && checkPos.func_177956_o() < worldHeight) {
                }
                if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != this.getPortalBlock()) continue;
                return checkPos.func_177981_b(1).func_185334_h();
            }
        }
        return null;
    }

    public BlockPos findSuitablePortalLocation(World world, Entity entity) {
        int y;
        int z;
        int x;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int posX = (int)Math.floor(entity.field_70165_t);
        int posY = (int)Math.floor(entity.field_70163_u);
        int posZ = (int)Math.floor(entity.field_70161_v);
        BlockPos planBPos = null;
        int searchRadius = ConfigurationUtil.MainConfig.portalSearchRadius;
        int worldHeight = world.func_72940_L();
        if (posY >= worldHeight) {
            posY = 65;
        }
        boolean cleanSpawn = true;
        for (x = posX - 2; x <= posX + 2 && cleanSpawn; ++x) {
            for (z = posZ - 2; z <= posZ + 2 && cleanSpawn; ++z) {
                for (y = posY + 1; y <= posY + 6 && cleanSpawn; ++y) {
                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x, y, z))) continue;
                    cleanSpawn = false;
                }
            }
        }
        if (cleanSpawn) {
            if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(posX, posY, posZ))) {
                return checkPos.func_181079_c(posX, posY + 2, posZ).func_185334_h();
            }
            planBPos = checkPos.func_181079_c(posX, posY + 2, posZ).func_185334_h();
        }
        for (int i = 1; i <= searchRadius; ++i) {
            int y3;
            int z3;
            int x3;
            for (int y2 = -i; y2 <= i; y2 += i * 2) {
                int y22 = posY + y2;
                if (y22 < 0 || y22 >= worldHeight) continue;
                int xNeg = -1;
                for (int x2 = 0; x2 <= i; ++x2) {
                    int x22 = posX + x2 * xNeg;
                    if (xNeg == 1 && x2 != 0) {
                        --x2;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z2 = 0; z2 <= i; ++z2) {
                        int z22 = posZ + z2 * zNeg;
                        if (zNeg == 1 && z2 != 0) {
                            --z2;
                        }
                        zNeg *= -1;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x22, y22, z22))) {
                            cleanSpawn = true;
                            for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x22, y22 + 2, z22).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x22, y22 + 2, z22).func_185334_h();
                    }
                }
            }
            int yNeg = -1;
            for (y = 0; y <= i - 1; ++y) {
                int y2 = posY + y * yNeg;
                if (y2 < 0 || y2 >= worldHeight) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z4 = 0; z4 <= i; ++z4) {
                    int z2 = posZ + z4 * zNeg;
                    if (zNeg == 1 && z4 != 0) {
                        --z4;
                    }
                    zNeg *= -1;
                    for (int x4 = -i; x4 <= i; x4 += i * 2) {
                        int x2 = posX + x4;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x2, y2, z2))) {
                            cleanSpawn = true;
                            for (x3 = x2 - 2; x3 <= x2 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z2 - 2; z3 <= z2 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y2 + 1; y3 <= y2 + 6 && cleanSpawn; ++y3) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x2, y2 + 2, z2).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x2 - 2; x3 <= x2 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z2 - 2; z3 <= z2 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y2 + 1; y3 <= y2 + 6 && cleanSpawn; ++y3) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x2, y2 + 2, z2).func_185334_h();
                    }
                }
                int xNeg = 1;
                for (int x5 = 1; x5 <= i - 1; ++x5) {
                    int x2 = posX + x5 * xNeg;
                    if (xNeg == 1 && x5 != 0) {
                        --x5;
                    }
                    xNeg *= -1;
                    for (int z5 = -i; z5 <= i; z5 += i * 2) {
                        int y32;
                        int z32;
                        int x32;
                        int z2 = posZ + z5;
                        if (!world.func_175623_d((BlockPos)checkPos.func_181079_c(x2, y2, z2))) {
                            cleanSpawn = true;
                            for (x32 = x2 - 2; x32 <= x2 + 2 && cleanSpawn; ++x32) {
                                for (z32 = z2 - 2; z32 <= z2 + 2 && cleanSpawn; ++z32) {
                                    for (y32 = y2 + 1; y32 <= y2 + 6 && cleanSpawn; ++y32) {
                                        if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x32, y32, z32))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.func_181079_c(x2, y2 + 2, z2).func_185334_h();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x32 = x2 - 2; x32 <= x2 + 2 && cleanSpawn; ++x32) {
                            for (z32 = z2 - 2; z32 <= z2 + 2 && cleanSpawn; ++z32) {
                                for (y32 = y2 + 1; y32 <= y2 + 6 && cleanSpawn; ++y32) {
                                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x32, y32, z32))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.func_181079_c(x2, y2 + 2, z2).func_185334_h();
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.func_181079_c(x, posY - 1, z);
                while (world.func_175623_d((BlockPos)checkPos.func_189536_c(EnumFacing.DOWN)) && checkPos.func_177956_o() >= 0) {
                }
                y = checkPos.func_177956_o();
                cleanSpawn = true;
                for (int x2 = x - 2; x2 <= x + 2 && cleanSpawn; ++x2) {
                    for (int z2 = z - 2; z2 <= z + 2 && cleanSpawn; ++z2) {
                        for (int y2 = y + 1; y2 <= y + 6 && cleanSpawn; ++y2) {
                            if (world.func_175623_d((BlockPos)checkPos.func_181079_c(x2, y2, z2))) continue;
                            cleanSpawn = false;
                        }
                    }
                }
                if (!cleanSpawn) continue;
                return checkPos.func_181079_c(x, y + 2, z).func_185334_h();
            }
        }
        if (planBPos != null) {
            return planBPos;
        }
        return entity.func_180425_c().func_177981_b(2).func_185334_h();
    }

    public BlockPos makePortal(World world, Entity entity, BlockPos pos) {
        if (world.field_73011_w.getDimension() == 0) {
            return pos;
        }
        BlockPos returnPos = pos;
        pos = pos.func_177977_b();
        IBlockState border = this.getBorderBlock().func_176223_P();
        IBlockState portal = this.getPortalBlock().func_176223_P();
        EnumFacing.Axis direction = EntityUtil.getDirectionFacing(entity, true).func_176740_k();
        if (direction == EnumFacing.Axis.X) {
            portal = portal.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST);
            for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                world.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z), border);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, z), border);
            }
            for (int y = pos.func_177956_o() + 1; y <= pos.func_177956_o() + 4; ++y) {
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 2), border);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 2), border);
            }
        } else {
            portal = portal.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH);
            for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                world.func_175656_a(new BlockPos(x, pos.func_177956_o(), pos.func_177952_p()), border);
                world.func_175656_a(new BlockPos(x, pos.func_177956_o() + 5, pos.func_177952_p()), border);
            }
            for (int y = pos.func_177956_o() + 1; y <= pos.func_177956_o() + 4; ++y) {
                world.func_175656_a(new BlockPos(pos.func_177958_n() - 2, y, pos.func_177952_p()), border);
                world.func_175656_a(new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p()), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p()), portal);
                world.func_175656_a(new BlockPos(pos.func_177958_n() + 2, y, pos.func_177952_p()), border);
            }
        }
        if (!world.func_180495_p(pos = pos.func_177977_b()).func_185914_p()) {
            this.makePortalPlatformAndDecorate(world, pos, direction);
        }
        return returnPos;
    }

    public void makePortalPlatformAndDecorate(World world, BlockPos pos, EnumFacing.Axis direction) {
        IBlockState border = this.getBorderBlock().func_176223_P();
        for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
            for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                world.func_175656_a(new BlockPos(x, pos.func_177956_o(), z), border);
            }
        }
    }

    public void placeInPortal(World world, Entity entity, BlockPos pos) {
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        } else {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        }
    }

    public abstract HashMap<Long, BlockPos> getCachedPortalMap();

    public abstract PortalBlock getPortalBlock();

    public abstract Block getBorderBlock();

    public boolean isVanilla() {
        return false;
    }
}

