/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.particles.FlickeringFluffyTrailParticle;
import net.tslat.aoa3.client.particles.FluffyTrailParticle;
import net.tslat.aoa3.client.particles.LingeringFluffyTrailParticle;
import net.tslat.aoa3.client.particles.PortalFloaterParticle;
import net.tslat.aoa3.client.particles.RainbowFluffyParticle;
import net.tslat.aoa3.client.particles.StarParticle;
import net.tslat.aoa3.client.particles.SwirlyTrailParticle;

public class ParticleRegister {
    private static TextureAtlasSprite PARTICLES_ATLAS = null;
    private static double PARTICLES_ATLAS_PIXEL_RATIO = 1.0;
    public static final EnumParticleTypes STAR = ParticleRegister.registerParticle("star", false, 4);
    public static final EnumParticleTypes FLUFFY = ParticleRegister.registerParticle("fluffy_trail", false, 4);
    public static final EnumParticleTypes FLICKERING_FLUFFY = ParticleRegister.registerParticle("flickering_fluffy_trail", false, 4);
    public static final EnumParticleTypes RAINBOW_FLUFFY = ParticleRegister.registerParticle("rainbow_fluffy_trail", false, 3);
    public static final EnumParticleTypes LINGERING_FLUFFY_TRAIL = ParticleRegister.registerParticle("lingering_fluffy_trail", false, 3);
    public static final EnumParticleTypes PORTAL_FLOATER = ParticleRegister.registerParticle("portal_floater", false, 2);
    public static final EnumParticleTypes SWIRLY = ParticleRegister.registerParticle("swirly_trail", false, 3);

    public static TextureAtlasSprite getTextureAtlas() {
        return PARTICLES_ATLAS;
    }

    public static double getParticleTextureRatio() {
        return PARTICLES_ATLAS_PIXEL_RATIO;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stitchEvent(TextureStitchEvent.Pre ev) {
        PARTICLES_ATLAS = ev.getMap().func_174942_a(new ResourceLocation("aoa3", "particles/particles"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void doInitTasks() {
        PARTICLES_ATLAS_PIXEL_RATIO = PARTICLES_ATLAS.func_94209_e() / (float)PARTICLES_ATLAS.func_130010_a();
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        manager.func_178929_a(FLUFFY.func_179348_c(), (IParticleFactory)new FluffyTrailParticle.Factory());
        manager.func_178929_a(FLICKERING_FLUFFY.func_179348_c(), (IParticleFactory)new FlickeringFluffyTrailParticle.Factory());
        manager.func_178929_a(RAINBOW_FLUFFY.func_179348_c(), (IParticleFactory)new RainbowFluffyParticle.Factory());
        manager.func_178929_a(LINGERING_FLUFFY_TRAIL.func_179348_c(), (IParticleFactory)new LingeringFluffyTrailParticle.Factory());
        manager.func_178929_a(PORTAL_FLOATER.func_179348_c(), (IParticleFactory)new PortalFloaterParticle.Factory());
        manager.func_178929_a(SWIRLY.func_179348_c(), (IParticleFactory)new SwirlyTrailParticle.Factory());
        manager.func_178929_a(STAR.func_179348_c(), (IParticleFactory)new StarParticle.Factory());
    }

    private static EnumParticleTypes registerParticle(String name, boolean ignoreRange, int argumentsCount) {
        return (EnumParticleTypes)EnumHelper.addEnum(EnumParticleTypes.class, (String)("AOA3_" + name.toUpperCase()), (Class[])new Class[]{String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE}, (Object[])new Object[]{"aoa3_" + name, EnumParticleTypes.values().length, ignoreRange, argumentsCount});
    }
}

