/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.client.gui.render.XpParticlesRenderer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class PacketXpGain
implements IMessage {
    private int skillId;
    private float xp;
    private boolean levelUp;

    public PacketXpGain() {
    }

    public PacketXpGain(int skill, float xp, boolean isLevelUp) {
        this.skillId = skill;
        this.xp = xp;
        this.levelUp = isLevelUp;
    }

    public void fromBytes(ByteBuf buffer) {
        this.skillId = buffer.readInt();
        this.xp = buffer.readFloat();
        this.levelUp = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.skillId);
        buffer.writeFloat(this.xp);
        buffer.writeBoolean(this.levelUp);
    }

    public static class Handler
    implements IMessageHandler<PacketXpGain, IMessage> {
        public IMessage onMessage(PacketXpGain msg, MessageContext ctx) {
            if (ConfigurationUtil.MainConfig.showXpParticles) {
                XpParticlesRenderer.addXpParticle(Enums.Skills.getById(msg.skillId), msg.xp, msg.levelUp);
            }
            return null;
        }
    }
}

