/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;

public class PacketToastPopup
implements IMessage {
    private ToastPopupType type;
    private Object subject;
    private Object value;

    public PacketToastPopup() {
    }

    public PacketToastPopup(Enums.Skills skill, int levelReq) {
        this.type = ToastPopupType.SKILL_REQUIREMENT;
        this.value = levelReq;
        this.subject = skill;
    }

    public PacketToastPopup(Enums.Resources resource, float amount) {
        this.type = ToastPopupType.RESOURCE_REQUIREMENT;
        this.value = Float.valueOf(amount);
        this.subject = resource;
    }

    public PacketToastPopup(Enums.Deities deity, int tributeAmount) {
        this.type = ToastPopupType.TRIBUTE_REQUIREMENT;
        this.subject = deity;
        this.value = tributeAmount;
    }

    public void fromBytes(ByteBuf buffer) {
        this.type = ToastPopupType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        switch (this.type) {
            case SKILL_REQUIREMENT: {
                this.subject = Enums.Skills.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                this.value = buffer.readInt();
                break;
            }
            case RESOURCE_REQUIREMENT: {
                this.subject = Enums.Resources.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                this.value = Float.valueOf(buffer.readFloat());
                break;
            }
            case TRIBUTE_REQUIREMENT: {
                this.subject = Enums.Deities.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                this.value = buffer.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.type.toString());
        switch (this.type) {
            case SKILL_REQUIREMENT: 
            case TRIBUTE_REQUIREMENT: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.subject.toString());
                buffer.writeInt(((Integer)this.value).intValue());
                break;
            }
            case RESOURCE_REQUIREMENT: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.subject.toString());
                buffer.writeFloat(((Float)this.value).floatValue());
            }
        }
    }

    public static enum ToastPopupType {
        SKILL_REQUIREMENT,
        RESOURCE_REQUIREMENT,
        TRIBUTE_REQUIREMENT;

    }

    public static class Handler
    implements IMessageHandler<PacketToastPopup, IMessage> {
        public IMessage onMessage(PacketToastPopup message, MessageContext ctx) {
            AdventOfAscension.proxy.displayToast(message.type, message.subject, message.value);
            return null;
        }
    }
}

