/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;

public class PacketRecoil
implements IMessage {
    private float recoilAmount;
    private int firingTime;

    public PacketRecoil() {
    }

    public PacketRecoil(float recoil, int firingDelay) {
        this.recoilAmount = recoil;
        this.firingTime = firingDelay;
    }

    public void fromBytes(ByteBuf buffer) {
        this.recoilAmount = buffer.readFloat();
        this.firingTime = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat(this.recoilAmount);
        buffer.writeInt(this.firingTime);
    }

    public static class Handler
    implements IMessageHandler<PacketRecoil, IMessage> {
        public IMessage onMessage(PacketRecoil msg, MessageContext ctx) {
            AdventOfAscension.proxy.addRecoil(msg.recoilAmount, msg.firingTime);
            return null;
        }
    }
}

