/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameRules;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class CommandTslat
extends CommandBase {
    private BlockPos structureMinPos = null;
    private BlockPos structureMaxPos = null;

    public String func_71517_b() {
        return "tslat";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Only Tslat can use this command. It's just for debugging purposes, don't worry";
    }

    public List<String> func_71514_a() {
        return Collections.EMPTY_LIST;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer && (sender.func_70005_c_().equals("Tslat") || sender.func_70005_c_().equals("Ursun_"))) {
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Welcome back."));
                return;
            }
            switch (args[0]) {
                case "pos1": {
                    this.structureMinPos = sender.func_180425_c().func_177977_b();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Set lower structure coordinate bounds to: " + this.structureMinPos.func_177958_n() + ", " + this.structureMinPos.func_177956_o() + ", " + this.structureMinPos.func_177952_p()));
                    break;
                }
                case "pos2": {
                    this.structureMaxPos = sender.func_180425_c().func_177977_b();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Set upper structure coordinate bounds to: " + this.structureMaxPos.func_177958_n() + ", " + this.structureMaxPos.func_177956_o() + ", " + this.structureMaxPos.func_177952_p()));
                    break;
                }
                case "capture": {
                    if (this.structureMinPos == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Missing lower structure coordinate bounds"));
                        break;
                    }
                    if (this.structureMaxPos == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Missing upper structure coordinate bounds"));
                        break;
                    }
                    int minX = Math.min(this.structureMinPos.func_177958_n(), this.structureMaxPos.func_177958_n());
                    int minY = Math.min(this.structureMinPos.func_177956_o(), this.structureMaxPos.func_177956_o());
                    int minZ = Math.min(this.structureMinPos.func_177952_p(), this.structureMaxPos.func_177952_p());
                    int maxX = Math.max(this.structureMinPos.func_177958_n(), this.structureMaxPos.func_177958_n());
                    int maxY = Math.max(this.structureMinPos.func_177956_o(), this.structureMaxPos.func_177956_o());
                    int maxZ = Math.max(this.structureMinPos.func_177952_p(), this.structureMaxPos.func_177952_p());
                    this.structureMinPos = new BlockPos(minX, minY, minZ);
                    this.structureMaxPos = new BlockPos(maxX, maxY, maxZ);
                    EntityPlayer pl = (EntityPlayer)sender;
                    Block fillBlock = null;
                    if (pl.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBlock) {
                        fillBlock = Block.func_149634_a((Item)pl.func_184586_b(EnumHand.MAIN_HAND).func_77973_b());
                    }
                    System.out.print("    @Override\n");
                    System.out.print("    protected void build(World world, Random rand, BlockPos basePos) {\n");
                    int blockCount = 0;
                    int fillBlockCount = 0;
                    int height = 1 + this.structureMaxPos.func_177956_o() - this.structureMinPos.func_177956_o();
                    int width = 1 + this.structureMaxPos.func_177958_n() - this.structureMinPos.func_177958_n();
                    int depth = 1 + this.structureMaxPos.func_177952_p() - this.structureMinPos.func_177952_p();
                    HashSet<IBlockState> capturedBlocks = new HashSet<IBlockState>();
                    for (int y = this.structureMinPos.func_177956_o(); y <= this.structureMaxPos.func_177956_o(); ++y) {
                        for (int x = this.structureMinPos.func_177958_n(); x <= this.structureMaxPos.func_177958_n(); ++x) {
                            for (int z = this.structureMinPos.func_177952_p(); z <= this.structureMaxPos.func_177952_p(); ++z) {
                                IBlockState blockState = pl.field_70170_p.func_180495_p(new BlockPos(x, y, z));
                                Block block = blockState.func_177230_c();
                                if (block == Blocks.field_150350_a || block == Blocks.field_150355_j && block.func_176201_c(blockState) != 0 || block == Blocks.field_150353_l && block.func_176201_c(blockState) != 0) continue;
                                if (fillBlock != null && block == fillBlock) {
                                    block = Blocks.field_150350_a;
                                    ++fillBlockCount;
                                    capturedBlocks.add(Blocks.field_150350_a.func_176223_P());
                                } else {
                                    capturedBlocks.add(blockState);
                                }
                                ++blockCount;
                                StringBuilder builder = new StringBuilder(" // ");
                                if (!blockState.func_177228_b().isEmpty() && blockState != block.func_176223_P()) {
                                    for (Map.Entry stateMap : blockState.func_177228_b().entrySet()) {
                                        builder.append(((IProperty)stateMap.getKey()).func_177699_b().toString()).append(" ## ");
                                        builder.append(((IProperty)stateMap.getKey()).func_177701_a()).append(" :: ");
                                        builder.append(((Comparable)stateMap.getValue()).toString()).append("; ");
                                    }
                                }
                                if (block.func_176201_c(blockState) != 0) {
                                    block.func_176201_c(blockState);
                                }
                                String comment = builder.length() > 4 ? builder.toString() : "";
                                System.out.print("        addBlock(world, basePos, " + (x - this.structureMinPos.func_177958_n()) + ", " + (y - this.structureMinPos.func_177956_o()) + ", " + (z - this.structureMinPos.func_177952_p()) + ", " + block.func_149739_a().replace("tile.", "") + "); " + comment + "\n");
                            }
                        }
                    }
                    System.out.print("    }\n");
                    System.out.print("\n");
                    for (IBlockState capturedBlock : capturedBlocks) {
                        String blockName = capturedBlock.func_177230_c().func_149739_a().replace("tile.", "").toUpperCase();
                        System.out.print("    private static final IBlockState " + blockName + " = " + (capturedBlock.func_177230_c().getRegistryName().func_110624_b().equals("minecraft") ? "Blocks" : "BlockRegister") + "." + blockName + ".getDefaultState();\n");
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Finished capturing structure. Stats:"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(fillBlock == null ? "No fill block found, skipping air gaps." : "Found " + fillBlock.func_149732_F() + " air gap marker."));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Size (X,Y,Z): " + width + "x" + height + "x" + depth));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Captured " + blockCount + " blocks." + (fillBlockCount > 0 ? " Includes " + fillBlockCount + " air gap blocks" : "")));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Contains " + capturedBlocks.size() + " unique blocks"));
                    break;
                }
                case "checkversions": {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Forge Version: " + ForgeVersion.getVersion()));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Minecraft Version: 1.12.2"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Mod Version: 3.3.6"));
                    break;
                }
                case "idregistercheck": {
                    int maxBlocks = 0;
                    int maxItems = 0;
                    int maxPotions = 0;
                    int maxBiomes = 0;
                    int maxEntities = 0;
                    int maxEnchantments = 0;
                    int aoaBlocks = 0;
                    int aoaItems = 0;
                    int aoaPotions = 0;
                    int aoaBiomes = 0;
                    int aoaEntities = 0;
                    int aoaEnchantments = 0;
                    try {
                        GameData dataClass = new GameData();
                        Field maxBlocksField = GameData.class.getDeclaredField("MAX_BLOCK_ID");
                        Field maxItemsField = GameData.class.getDeclaredField("MAX_ITEM_ID");
                        Field maxPotionsField = GameData.class.getDeclaredField("MAX_POTION_ID");
                        Field maxBiomesField = GameData.class.getDeclaredField("MAX_BIOME_ID");
                        Field maxEntitiesField = GameData.class.getDeclaredField("MAX_ENTITY_ID");
                        Field maxEnchantmentsField = GameData.class.getDeclaredField("MAX_ENCHANTMENT_ID");
                        if (maxBlocksField != null) {
                            maxBlocksField.setAccessible(true);
                            maxBlocks = maxBlocksField.getInt(dataClass);
                        }
                        if (maxItemsField != null) {
                            maxItemsField.setAccessible(true);
                            maxItems = maxItemsField.getInt(dataClass);
                        }
                        if (maxPotionsField != null) {
                            maxPotionsField.setAccessible(true);
                            maxPotions = maxPotionsField.getInt(dataClass);
                        }
                        if (maxBiomesField != null) {
                            maxBiomesField.setAccessible(true);
                            maxBiomes = maxBiomesField.getInt(dataClass);
                        }
                        if (maxEntitiesField != null) {
                            maxEntitiesField.setAccessible(true);
                            maxEntities = maxEntitiesField.getInt(dataClass);
                        }
                        if (maxEnchantmentsField != null) {
                            maxEnchantmentsField.setAccessible(true);
                            maxEnchantments = maxEnchantmentsField.getInt(dataClass);
                        }
                    }
                    catch (Exception dataClass) {
                        // empty catch block
                    }
                    for (Block bl : ForgeRegistries.BLOCKS) {
                        if (bl.getRegistryName() == null || !bl.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaBlocks;
                    }
                    for (Item item : ForgeRegistries.ITEMS) {
                        if (item.getRegistryName() == null || !item.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaItems;
                    }
                    for (Potion potion : ForgeRegistries.POTIONS) {
                        if (potion.getRegistryName() == null || !potion.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaPotions;
                    }
                    for (Biome biome : ForgeRegistries.BIOMES) {
                        if (biome.getRegistryName() == null || !biome.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaBiomes;
                    }
                    for (EntityEntry entity : ForgeRegistries.ENTITIES) {
                        if (entity.getRegistryName() == null || !entity.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaEntities;
                    }
                    for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                        if (enchantment.getRegistryName() == null || !enchantment.getRegistryName().func_110624_b().equals("aoa3")) continue;
                        ++aoaEnchantments;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total blocks registered: " + ForgeRegistries.BLOCKS.getValuesCollection().size() + "/" + maxBlocks + " (" + aoaBlocks + " from AoA)"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total items registered: " + ForgeRegistries.ITEMS.getValuesCollection().size() + "/" + maxItems + " (" + aoaItems + " from AoA)"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total potions registered: " + ForgeRegistries.POTIONS.getValuesCollection().size() + "/" + maxPotions + " (" + aoaPotions + " from AoA)"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total biomes registered: " + ForgeRegistries.BIOMES.getValuesCollection().size() + "/" + maxBiomes + " (" + aoaBiomes + " from AoA)"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total entities registered: " + ForgeRegistries.ENTITIES.getValuesCollection().size() + "/" + maxEntities + " (" + aoaEntities + " from AoA)"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Total enchantments registered: " + ForgeRegistries.ENTITIES.getValuesCollection().size() + "/" + maxEnchantments + " (" + aoaEnchantments + " from AoA)"));
                    break;
                }
                case "heal": {
                    EntityPlayer player = (EntityPlayer)sender;
                    if (player.field_70170_p.field_72995_K) break;
                    player.func_70691_i(player.func_110138_aP());
                    player.func_71024_bL().func_75122_a(999, 1.0f);
                    player.func_70066_B();
                    PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
                    plData.stats().regenResource(Enums.Resources.RAGE, 200.0f);
                    plData.stats().regenResource(Enums.Resources.SOUL, 200.0f);
                    plData.stats().regenResource(Enums.Resources.ENERGY, 200.0f);
                    plData.stats().regenResource(Enums.Resources.CREATION, 200.0f);
                    break;
                }
                case "explode": {
                    float altStrength;
                    EntityPlayer player = (EntityPlayer)sender;
                    if (player.field_70170_p.field_72995_K) break;
                    float strength = 7.0f;
                    if (args.length > 1 && (altStrength = StringUtil.toFloat(args[1])) > 0.0f) {
                        strength = altStrength;
                    }
                    WorldUtil.createExplosion((Entity)player, player.field_70170_p, strength);
                    break;
                }
                case "toggledebugsetup": {
                    EntityPlayer player = (EntityPlayer)sender;
                    GameRules gameRules = player.field_70170_p.func_82736_K();
                    WorldInfo worldInfo = player.field_70170_p.func_72912_H();
                    if (gameRules.func_82766_b("doMobSpawning")) {
                        gameRules.func_82764_b("doMobSpawning", "false");
                        gameRules.func_82764_b("doWeatherCycle", "false");
                        gameRules.func_82764_b("doDaylightCycle", "false");
                        worldInfo.func_176142_i(20000000);
                        worldInfo.func_76080_g(0);
                        worldInfo.func_76090_f(0);
                        worldInfo.func_76084_b(false);
                        worldInfo.func_76069_a(false);
                        player.field_70170_p.func_72877_b(1000L);
                        player.func_145747_a((ITextComponent)new TextComponentString("Enabled Debug settings"));
                        break;
                    }
                    gameRules.func_82764_b("doMobSpawning", "true");
                    gameRules.func_82764_b("doWeatherCycle", "true");
                    gameRules.func_82764_b("doDaylightCycle", "true");
                    worldInfo.func_176142_i((300 + AdventOfAscension.rand.nextInt(600)) * 20);
                    player.field_70170_p.func_72877_b(1000L);
                    player.func_145747_a((ITextComponent)new TextComponentString("Disabled Debug settings"));
                    break;
                }
            }
        }
    }

    public int func_82362_a() {
        return 4;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer && (AdventOfAscension.instance().isTslat(((EntityPlayer)sender).func_146103_bH().getId()) || AdventOfAscension.instance().isUrsun(((EntityPlayer)sender).func_146103_bH().getId()));
    }
}

