/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.StringUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class CommandAoAStructure
extends CommandBase {
    private static final TextComponentString commandPrefix = new TextComponentString(TextFormatting.DARK_RED + "[AoA" + TextFormatting.GOLD + "Structure" + TextFormatting.DARK_RED + "] ");

    public String func_71517_b() {
        return "aoastructure";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.aoastructure.usage";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("aoastructures");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoastructure.desc", new String[0]);
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            int pageIndex = 1;
            int pageCount = StructuresHandler.getStructureListPageCount();
            if (args.length > 1 && NumberUtils.isCreatable((String)args[1])) {
                try {
                    pageIndex = MathHelper.func_76125_a((int)Integer.parseInt(args[1]), (int)1, (int)pageCount);
                }
                catch (Exception e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[1]);
                    return;
                }
            }
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "--", new String[0]);
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoastructure.list", StructuresHandler.getStructuresList(pageIndex));
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "", new String[0]);
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoastructure.page", String.valueOf(pageIndex), String.valueOf(pageCount));
            return;
        }
        if (args.length < 2 || args.length < 4 && !args[1].equalsIgnoreCase("here")) {
            this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoastructure.usage", new String[0]);
            return;
        }
        AoAStructure structure = StructuresHandler.getStructure(args[0]);
        if (structure != StructuresHandler.EMPTY_STRUCTURE) {
            BlockPos generationPos = this.evaluatePosition(sender, args);
            if (!sender.func_130014_f_().func_190526_b(generationPos.func_177958_n(), generationPos.func_177952_p())) {
                sender.func_130014_f_().func_72863_F().func_186025_d(generationPos.func_177958_n() >> 4, generationPos.func_177952_p() >> 4);
            }
            StructuresHandler.generateStructure(structure, sender.func_130014_f_(), null, generationPos);
            this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoastructure.success", args[0], String.valueOf(generationPos.func_177958_n()), String.valueOf(generationPos.func_177956_o()), String.valueOf(generationPos.func_177952_p()));
        } else {
            this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoastructure.invalid", args[0]);
        }
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return StructuresHandler.autoCompleteStructureName(args[args.length - 1]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    private BlockPos evaluatePosition(ICommandSender sender, String[] args) throws CommandException {
        if (args[1].equals("here")) {
            if (sender instanceof EntityPlayerMP) {
                return sender.func_180425_c();
            }
            throw new WrongUsageException("command.aoa.noConsole", new Object[]{"Here"});
        }
        if (args.length >= 4) {
            int posX = 0;
            int posY = 0;
            int posZ = 0;
            block7: for (int i = 1; i < 4; ++i) {
                int coord;
                boolean relative = false;
                String s = args[i];
                if (s.startsWith("~")) {
                    s = s.substring(1);
                    relative = true;
                }
                try {
                    coord = args[i].length() == 1 && relative ? 0 : Integer.parseInt(s);
                }
                catch (Exception e) {
                    throw new WrongUsageException("command.aoa.invalidArgument", new Object[]{args[i]});
                }
                if (relative && !(sender instanceof EntityPlayerMP)) {
                    throw new WrongUsageException("command.aoa.noConsole", new Object[]{"~"});
                }
                switch (i) {
                    case 1: {
                        posX = relative ? (int)((EntityPlayerMP)sender).field_70165_t + coord : coord;
                        continue block7;
                    }
                    case 2: {
                        posY = relative ? (int)((EntityPlayerMP)sender).field_70163_u + coord : coord;
                        continue block7;
                    }
                    case 3: {
                        posZ = relative ? (int)((EntityPlayerMP)sender).field_70161_v + coord : coord;
                    }
                }
            }
            return new BlockPos(posX, posY, posZ);
        }
        throw new WrongUsageException("command.aoastructure.usage", new Object[0]);
    }

    private void messageSender(ICommandSender sender, Enums.CommandFeedbackType type, String langKey, String ... args) {
        sender.func_145747_a(commandPrefix.func_150259_f().func_150257_a(StringUtil.getLocaleWithArguments(langKey, args).func_150255_a(new Style().func_150238_a(type.getColour()))));
    }
}

